import QtQuick 1.0

Item {
    id: container
    width: parent.width
    height: parent.height

    property color barColor: "#68C8FF"
    property int duration : 300
    property real progress: 0

    Rectangle {
        id: border

        anchors.fill: parent
        color: "white"
        border.color: "#68C8FF"
        border.width: 4
        radius: 10
        smooth: true

        ProgressBar {
            id: innerProgressBar
            width: parent.width - 20
            height: parent.height - 16
            anchors.centerIn: parent
            barColor: container.barColor
            duration: container.duration + 100
            radius: 5

            progress: container.progress
        }
    }

    states: State {
        name: "hideContainer"
        when: (container.progress==0 || container.progress==1)

        PropertyChanges { target: container; opacity: 0 }
    }

    Behavior on opacity { NumberAnimation { duration: duration } }
}
