import QtQuick 1.0

MouseArea {

    property real deltaLR: 50
    property real deltaUD: 30

    anchors.fill: parent
    signal swipeRight;
    signal swipeLeft;
    signal swipeUp;
    signal swipeDown;

    property int startX;
    property int startY;

    onPressed: {
        startX = mouse.x;
        startY = mouse.y;
    }

    onReleased: {
        var deltax = mouse.x - startX;
        var deltay = mouse.y - startY;

        if (Math.abs(deltax) > deltaLR || Math.abs(deltay) > deltaLR) {
            if (deltax > deltaUD && Math.abs(deltay) < deltaUD) {
                // swipe right
                swipeRight();
            } else if (deltax < -deltaUD && Math.abs(deltay) < deltaUD) {
                // swipe left
                swipeLeft();
            } else if (Math.abs(deltax) < deltaUD && deltay > deltaUD) {
                // swipe down
                swipeDown();
            } else if (Math.abs(deltax) < deltaUD && deltay < deltaUD) {
                // swipe up
                swipeUp();
            }
        }
    }
}
