import QtQuick 1.0

Item {
    id: dialog

    property bool busyIndicatorOn : false
    property int duration : 600
    property alias message : message.text
    property int refWidth: parent.width

    width: message.width + 70
    height: message.height + 40

    Rectangle {
        id: border

        anchors.fill: dialog
        color: "white"
        border.color: "#68C8FF"
        border.width: 4
        radius: 10
        smooth: true
    }

    Image {
        id: busyIndicator

        width: (busyIndicatorOn) ? 40 : 15
        visible: busyIndicatorOn
        height: 40
        anchors { left: dialog.left; leftMargin: 10; verticalCenter: dialog.verticalCenter }
        source: "gfx/busy.png"
        sourceSize.width: 40
        sourceSize.height: 40
        smooth: true

        NumberAnimation on rotation {
            running: dialog.opacity > 0; from: 0; to: 360; loops: Animation.Infinite; duration: 1300
        }
    }

    Text {
        id: message

        anchors { left: busyIndicator.right; leftMargin: 10; verticalCenter: dialog.verticalCenter }
        font.pixelSize: 28
        color: "#595454"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.Wrap
        smooth: true
        text: "Loading" //qsTr("Loading...")
    }

    Behavior on opacity { NumberAnimation { duration: duration } }
}
