import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480
    //color: "#B0D8FF"
    property bool txtSmooth: true
    property color statColor: "#595454"
    property int statTopMargin: 1
    property int listFontSize : 48
    property int fontSize1: listFontSize - 18
    property int fontSize2: listFontSize - 28
    property int fontSize3: listFontSize - 20
    property bool isLandscape: ( width > height )
    property string activeFeedUrl: ""
    property string description: ""

    signal inMainView

    ProgressBar {
        id: newsModelProgress
        width: 300
        height: 15
        anchors.centerIn: parent
        barColor: "#68C8FF"
        radius: 8

        progress: rssModel.progress

        states: State {
            name: "hideProgress"
            when: (rssModel.status!=XmlListModel.Loading)
            PropertyChanges { target: newsModelProgress; opacity: 0 }
        }
    }

    BusyDialog {
        id: newsErrorDialog
        anchors.centerIn: parent
        message: "RSS feed unavailable"
        duration: 600

        states: [ State {
                name: "showError"
                when: (rssModel.status==XmlListModel.Error)
                PropertyChanges { target: newsErrorDialog; opacity: 1 }
                PropertyChanges { target: newsErrorDialog; message: "RSS feed unavailable" }
            },
            State {
                name: "hideError"
                when: (rssModel.status!=XmlListModel.Error)
                PropertyChanges { target: newsErrorDialog; opacity: 0 }
            }
        ]
    }

    // Flickable area to display detail info
    Rectangle {
        id: descRect
        anchors.fill: parent
        color: "ivory"
        opacity: 0

        Flickable {
            id: descFlick
            anchors.fill: parent
            anchors { topMargin: 10; bottomMargin: 10; leftMargin: 10; rightMargin: 10 }
            //height: parent.height
            //anchors { top: parent.top; bottom: parent.bottom; right: parent.right; topMargin: 10; rightMargin: 10 }
            contentHeight: descText.height + 60
            clip: true

            Text {
                id: descText;
                wrapMode: Text.WordWrap;
                anchors { left: parent.left; right: parent.right; }
                font.pixelSize: fontSize3
                text: description
            }

            SimpleButton{
                id: readMoreText
                width: parent.width
                anchors { left: descText.left; right: parent.right; top: descText.bottom; topMargin: 20 }
                text: "Read More"
                textSize: fontSize3

                onClicked: {
                    Qt.openUrlExternally(newsView.model.get(newsView.currentIndex).link);
                }
            }

            MouseArea {
                id: detailMouseArea
                anchors.fill: descText
                onClicked: {
                    // TODO: Context menu to open link or stats view
                    container.state='';
                }
            }
        }
    }

    ListView {
        id: newsView
        anchors.fill: parent
        model: rssModel
        delegate: newsDelegate
        snapMode: ListView.SnapToItem
        focus: true
        section.property: "date"
        section.criteria: ViewSection.FullString
        section.delegate: sectionComp
        visible: rssModel.status==XmlListModel.Ready
     }

    Component {
        id: sectionComp

        Rectangle {
            width: container.width
            height: childrenRect.height
            color: "#E4F5FF"

            Text {
                id: sectionText

                smooth: txtSmooth
                color: statColor
                font.pixelSize: fontSize2
                horizontalAlignment: Text.AlignRight
                text: "   " + section
            }
        }
    }

    Component {
        id: newsDelegate

        Item {
            id: newsDelegateItem
            width: newsView.width
            height: titleBox.height + 45 //80

            property real detailOpacity: 0
            property real titleOpacity: 1

            Rectangle {
                id: background
                x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: "ivory"
                border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: titleBox
                opacity: titleOpacity
                anchors { top: background.top; left: background.left; right: background.right; leftMargin: 10; rightMargin: 10; topMargin: 5 }

                smooth: txtSmooth
                //font.bold: true
                font.pixelSize: fontSize1
                wrapMode: Text.WordWrap;
                text: title
            }

            Image {
                id: upDownArrow
                anchors { top: titleBox.bottom; right: background.right; rightMargin: 10; }

                width: 30
                height: 30
                source: "gfx/rnd_br_down.png"
                smooth: txtSmooth
            }

            MouseArea {
                id: newsMouseArea
                anchors.fill: background
                onClicked: {
                    // TODO: Context menu to open link or stats view
                    newsDelegateItem.ListView.view.currentIndex = index
                    description = newsView.model.get(newsView.currentIndex).desc

                    if (container.state == "details") { container.state=''; }
                    else                              { container.state='details'; }
                }
            }

            //Binding { target: descText; property: "text"; value: desc; when: newsDelegateItem.ListView.isCurrentItem }

            /* This is unstable
            Item {
                id: details
                x: 20; width: parent.width - 2*x
                anchors { top: parent.top; topMargin: 10; bottom: parent.bottom; bottomMargin: 10 }
                opacity: newsDelegateItem.detailOpacity
                clip: true

                // Flickable area to display detail info
                Flickable {
                    id: flick
                    width: parent.width
                    //height: parent.height
                    anchors { top: parent.top; bottom: parent.bottom; right: parent.right; topMargin: 10; rightMargin: 10 }
                    contentHeight: descText.height + 60
                    clip: true

                    Text {
                        id: descText;
                        wrapMode: Text.WordWrap;
                        anchors { left: parent.left; right: parent.right; leftMargin: 10; rightMargin: 10 }
                        font.pixelSize: fontSize3
                        //font.format: Text.styledText
                        text: desc
                    }

                    SimpleButton{
                        id: readMoreText
                        width: parent.width
                        anchors { left: descText.left; top: descText.bottom; leftMargin: 10; topMargin: 40 }
                        text: "Read More"
                        textSize: fontSize3

                        onClicked: {
                            Qt.openUrlExternally(link);

                        }
                    }

                    MouseArea {
                        id: detailMouseArea
                        anchors.fill: descText
                        onClicked: {
                            // TODO: Context menu to open link or stats view
                            if (newsDelegateItem.state == "details") { newsDelegateItem.state=''; }
                            else                                     { newsDelegateItem.state='details'; }
                        }
                    }
                }
            }


            states: State {
                name: "details"

                PropertyChanges { target: upDownArrow; source: "gfx/rnd_br_up.png" }

                // Make titleBox disappear for Google
                PropertyChanges { target: titleBox; opacity: 0 }
                //PropertyChanges { target: background; opacity: 0 }

                // Make details visible
                PropertyChanges { target: newsDelegateItem; detailOpacity: 1; }
                // Fill the entire list area with the detailed view
                PropertyChanges { target: newsDelegateItem; height: newsView.height }

                // Disallow flicking while we're in detailed view
                PropertyChanges { target: newsDelegateItem.ListView.view; interactive: false }

                // Move the list so that this item is at the top.
                StateChangeScript {
                    name: "detailView"
                    script: {
                        // Available after QtQuick 1.1
                        //newsDelegateItem.ListView.view.positionViewAtBeginning();
                        newsDelegateItem.ListView.view.positionViewAtIndex(index, ListView.Contain);
                    }
                }
            }

            transitions: Transition {
                // Make the state changes smooth
                ParallelAnimation {
                    NumberAnimation { properties: "titleOpacity,detailOpacity"; duration: 150;  }
                    NumberAnimation { properties: "x,contentY,height"; duration: 300;  }
                    //SmoothedAnimation { properties: "x,contentY,height"; duration: 300;  }
                }
            }
            */
        }
    }


    states: State {
        name: "details"

        PropertyChanges { target: descRect; opacity: 1  }
        PropertyChanges { target: newsView; opacity: 0  }
    }

    transitions: [
        Transition {
            ParallelAnimation {
                PropertyAnimation { target: descRect; properties: "opacity"; duration: 130}
                PropertyAnimation { target: newsView; properties: "opacity"; duration: 130}
            }
        }
    ]

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 20; }
        focus: true
        width: 65
        height: 65
        onClicked: {
            if (container.state == "details") { container.state=''; }
            else                              {
                if (rssModel.status==XmlListModel.Error) {
                    activeFeedUrl = "";
                    rssModel.reload();
                }

                container.inMainView();
            }
        }
    }
}


