#ifndef FILEHANDLER_H
#define FILEHANDLER_H

#include <QIODevice>
#include <QFile>
#include <QTextStream>
#include <iostream>
#include <QObject>
#include <QString>
#include <QStringList>
#include <QList>
#include <QDebug>

class FileHandler : public QObject
{
    Q_OBJECT
    Q_PROPERTY (QString localPfoName
                READ localPfoName)
    Q_PROPERTY (bool localIsYahoo
                READ localIsYahoo)
//    Q_PROPERTY (bool localExists
//                READ localExists)

public:
    explicit FileHandler(QObject *parent = 0);
    Q_INVOKABLE int storePfo(const QString &, const bool);
    Q_INVOKABLE int loadPfo();
    Q_INVOKABLE int deletePfo();

    QString localPfoName() const { return pfoName; }
    bool localIsYahoo() const { return isYahoo; }
//    bool localExists() const { return fileOk; }

signals:

public slots:

private:
    QString pfoName;
    bool isYahoo;
//    bool fileOk;
};

#endif // FILEHANDLER_H
