#include "filehandler.h"

FileHandler::FileHandler(QObject *parent) :
    QObject(parent)
{
}

//Q_INVOKABLE int FileHandler::storePfo (const QString &pfoName, const int share, const int cost, const bool isYahoo)
Q_INVOKABLE int FileHandler::storePfo (const QString &pfoName, const bool isYahoo)
{
  QFile f( "portfolio.txt" );

  if( !f.open( QIODevice::WriteOnly ) )
  {
    qDebug() << "Failed to open for write.";

    return -1;
  }

  QTextStream ts( &f );

  ts << pfoName << ":" << isYahoo << endl;
  qDebug() << pfoName << ":" << isYahoo;

  f.close();

  return 0;
}

//Q_INVOKABLE int FileHandler::loadPfo (QString &pfoName, int share, int cost, bool isYahoo )
Q_INVOKABLE int FileHandler::loadPfo ()
{
  QFile f( "portfolio.txt" );

  if( !f.exists() )
  {
    qDebug() << "Local portfolio does not exist.";

    return -1;
  }

  if( !f.open( QIODevice::ReadOnly ) )
  {
    qDebug() << "Failed to open for read.";

    return -1;
  }

  QTextStream ts( &f );

  QStringList strList;
  QStringList::const_iterator constIterator;

  while ( !ts.atEnd() ) {
      strList = ts.readLine().split(":");

      if (strList.length()==2) {
          for (constIterator = strList.constBegin(); constIterator != strList.constEnd(); ++constIterator) {
              //qDebug() << (*constIterator).toLocal8Bit().constData();
              if (constIterator==strList.constBegin())
                  pfoName = (*constIterator).toLocal8Bit().constData();
              else
                  isYahoo = (*constIterator).toLocal8Bit().constData();
          }
      }
      else {
          // delete portfolio file since it's invalid
          f.remove();
          qDebug() << "Error in loading local portfolio.";

          return -1;
      }
  }

  f.close();

  return 0;
}

Q_INVOKABLE int FileHandler::deletePfo() {
    QFile f( "portfolio.txt" );

    if( !f.exists() )
    {
      qDebug() << "Local portfolio does not exist.";

      return -1;
    }

    f.remove();
    qDebug() << "Delete local portfolio.";

    f.close();

    return 0;
}
