import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480

    property bool txtSmooth: true
    property color backgroundColor: "ivory"
    property color currentItemColor: "#FFF8C6"
    property color pressColor: "#FDE688"
    property int listFontSize : 32

    property bool editMode: false
    property bool pfoIsLocal: false

    property int selectedIdx: 0
    property int pfoLocalIdx: 0
    property bool pfoIsYahoo: false

    signal close

    ///////////////////////////////
    // function
    ///////////////////////////////
    function resetEditDialog() {
        editDialog.myName   = "";
        editDialog.myExg    = "";
        editDialog.myShare  = 0;
        editDialog.myCost   = 0;
        editDialog.myStop   = 0;
    }


    function reloadPoseditDialog(name, exchange, share, cost, isYahoo) {
        editDialog.myName   = name;
        editDialog.myExg    = exchange;
        editDialog.myShare  = share;
        editDialog.myCost   = cost;
        editDialog.myStop   = 0;
        editDialog.myIsYahoo = isYahoo;
    }

    function addPos(idx, update) {
        if (update) {
            posModel.set(idx, {
                         "name": checkForDelimiter(editDialog.myName.toUpperCase()),
                         "exchange": checkForDelimiter(editDialog.myExg.toUpperCase()),
                         "share": editDialog.myShare,
                         "shareCost": editDialog.myCost
            });
//            fileHandler.setPos(selectedIdx, editDialog.myName.toUpperCase(), editDialog.myExg.toUpperCase(), editDialog.myShare, editDialog.myCost, editDialog.myStop);
        }
        else {
            posModel.append({
                         "name": checkForDelimiter(editDialog.myName.toUpperCase()),
                         "exchange": checkForDelimiter(editDialog.myExg.toUpperCase()),
                         "share": editDialog.myShare,
                         "shareCost": editDialog.myCost
            });

//        fileHandler.storePosAll(activePos);
        }
    }

    function storePos() {
        fileHandler.removePosAll();

        for (var i=0; i<posModel.count; i++) {
            console.log("storePos: i=" + i + ", name=" + posModel.get(i).name);
            fileHandler.setPos(i, posModel.get(i).name, posModel.get(i).exchange, posModel.get(i).share, posModel.get(i).shareCost, 0);
        }

        fileHandler.storePosAll(activePos);
    }

    ListView {
        id: posEditView
        anchors.fill: parent
        anchors.bottomMargin: 90
        model: posModel
        delegate: posEditDelegate
        snapMode: ListView.SnapToItem
    }

    Component {
        id: posEditDelegate

        Item {
            id: posEditDelegateItem
            width: posEditView.width
            height: 75

            Rectangle {
                id: background
                x: 5; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: container.backgroundColor
//                border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: nameBox
                anchors { top: parent.top; left: parent.left; leftMargin: 20; topMargin: 5}

                font.bold: true
                font.pixelSize: listFontSize
                //verticalAlignment: Text.AlignVCenter
                text: name + ((exchange=="") ? "" : ("."+exchange))
            }

            Text {
                id: excerptBox
                anchors { top: nameBox.bottom; left: parent.left; leftMargin: 40; }

                color: "#808080"
                font.pixelSize: listFontSize - 10
                text: "Share: " + share + ", " + "Cost: " + shareCost
            }

            MouseArea {
                id: mouseArea
                anchors.fill: background
                onClicked: {
                    posName = posModel.get(index).name;
                    selectedIdx = index;
                    posEditDelegateItem.ListView.view.currentIndex = index;

                    if (mouse.x > (parent.width - 40)) {
                        if (pfoLocal&editMode) {
//                            deleteDialog.open();
                            // Immediately remove then
                            posModel.remove(selectedIdx);
                            storePos();

                            // Jump to previous item
                            selectedIdx = (selectedIdx>0) ? selectedIdx-1 : 0;
                        }
                    }
                    else {
                        reloadPosEditDialog(name, exchange, share, shareCost, pfoIsYahoo);
                        container.state = "entryUpdate";
                    }
                }
            }

            SimpleRect {
                id: deleteBox
                anchors { right: background.right; rightMargin: 10; }
                anchors.verticalCenter: background.verticalCenter
                width: 30
                color: "#FF5555"

                visible: (pfoIsLocal&editMode)

                text: "X"
                textColor: (pfoIsLocal&editMode) ? "white" : "grey"
                textSize: listFontSize
                radius: 10
           }

            states: [
                State {
                    name: "Pressed"
                    when: mouseArea.pressed
                    PropertyChanges { target: background; color: container.pressColor }
                },
                State {
                    name: "highlightCurrentItem"
                    when: selectedIdx == index
                    PropertyChanges { target: background; color: container.currentItemColor }
                }
            ]
        }
    }

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 10; }
        width: 65
        height: 65
        onClicked: {
            //fileHandler.storePosAll(pfoLocalIdx);
            container.close();
        }
    }

    Fader {
        fadingOpacity: 0.6
        // Bind our visibility status with Fader show/hide states.
        state: container.state!="" ? "faded" : ""
        transitionDuration: 200
        // Use the whole available area for fading & capturing key clicks.
        anchors.fill: parent
        // Use "light" fading color.
        color: "#f5f5f5"
    }

    TextButton {
        id: storeButton
        anchors { bottom: parent.bottom; right: addButton.left; rightMargin: 20; bottomMargin: 10; }
        width: 60
        height: storeButton.width
        radius: storeButton.width

        color: "#F2F2F2"
        lightColor: "#FFFFFF"
        pressColor: storeButton.color

        text: "v"
        textColor: "#B0D8FF"
        textSize: 60

        onClicked: {
            // Save pos
            updatePfoNum(posEditView.pfoLocalIdx);
            storePos();
            container.state = "";
        }
    }

    TextButton {
        id: addButton
        anchors { bottom: parent.bottom; right: parent.right; rightMargin: 20; bottomMargin: 10; }
        width: 60
        height: addButton.width
        radius: addButton.width

        color: "#F2F2F2"
        lightColor: "#FFFFFF"
        pressColor: addButton.color

        text: "+"
        textColor: "#B0D8FF"
        textSize: 60
        textBold: true

        onClicked: {
            resetEditDialog();
            container.state = "entry";
        }
    }

    Edit {
        id: editDialog
        state: "hidden"
        pfoMode: false
        myIsYahoo: pfoIsYahoo

        onSave: {
            if (editDialog.myName!="") {
                // console.log(editDialog.myName);
                if (container.state=="entryUpdate") { addPos(container.selectedIdx, 1); }
                else                                { addPos(container.selectedIdx, 0); }
            }

            container.state="";
        }
        onCancel: { container.state = "" }
    }

    states: [
        State {
            name: "entry"
            PropertyChanges { target: editDialog; state: "shown"  }
            StateChangeScript { script: { console.log("posEdit.entry");}}
        },
        State {
            name: "entryUpdate"
            PropertyChanges { target: editDialog; state: "shown"  }
            StateChangeScript { script: { console.log("posEdit.entryUpdate"); }}
        }
//        State {
//            name: "edit"
//            PropertyChanges { target: storeButton; visible: true  }
//            PropertyChanges { target: container; editMode: true  }
//        }
    ]
}
