#ifndef FILEHANDLER_H
#define FILEHANDLER_H

#include <string>
#include <QIODevice>
#include <QFile>
#include <QTextStream>
#include <iostream>
#include <QObject>
#include <QString>
#include <QStringList>
#include <QList>
#include <QVariant>
#include <QDebug>
#include <QDir>

//#define DBG

class FileHandler : public QObject
{
    Q_OBJECT

    // portfolio
    Q_PROPERTY (QVariantList localPfoName
                READ localPfoName)
    Q_PROPERTY (QVariantList localPfoNum
                READ localPfoNum)
    Q_PROPERTY (QVariantList localPfoDesc
                READ localPfoDesc)
    Q_PROPERTY (QVariantList localPfoIsYahoo
                READ localPfoIsYahoo)

    // position
    Q_PROPERTY (QVariantList localPosSymbol
                READ localPosSymbol)
    Q_PROPERTY (QVariantList localPosExg
                READ localPosExg)
    Q_PROPERTY (QVariantList localPosShare
                READ localPosShare)
    Q_PROPERTY (QVariantList localPosCost
                READ localPosCost)
    Q_PROPERTY (QVariantList localPosStop
                READ localPosStop)

public:
    explicit FileHandler(QObject *parent = 0);

    // portfolio
    Q_INVOKABLE int storePfoAll();
    Q_INVOKABLE int storePfo(QString , QString, bool);
    //Q_INVOKABLE int loadPfo();
    Q_INVOKABLE int loadPfo();
    Q_INVOKABLE void setPfo(int, QString , QString , bool);
    Q_INVOKABLE void removePfo(int);
    Q_INVOKABLE void removePfoAll();
    int deletePfo();
    void debugPfo();
    void updatePfoNum(int, int);

    // position
    Q_INVOKABLE int storePosAll(int);
    Q_INVOKABLE int storePos(int, QString, QString, int, int, int);
    Q_INVOKABLE int loadPos(int);
    Q_INVOKABLE void setPos(int, QString, QString, int , int, int);
    Q_INVOKABLE void removePos(int);
    Q_INVOKABLE void removePosAll();
    void removePosFile(int);

    // Utility function
    Q_INVOKABLE QVariantList calcPerformance(int, int);
    Q_INVOKABLE QVariantList parseCSV(const QString);

    void debugPos();
    int loadPosNum(int);

    // portfolio
    QVariantList localPfoName() const { return pfoModel.pfoName; }
    QVariantList localPfoNum() const { return pfoModel.pfoNum; }
    QVariantList localPfoDesc() const { return pfoModel.pfoDesc; }
    QVariantList localPfoIsYahoo() const { return pfoModel.pfoIsYahoo; }
    // position
    QVariantList localPosSymbol() const { return posSymbol; }
    QVariantList localPosExg() const { return posExg; }
    QVariantList localPosShare() const { return posShare; }
    QVariantList localPosCost() const { return posCost; }
    QVariantList localPosStop() const { return posStop; }

signals:

public slots:

private:
    struct pfoModelType {
        QVariantList pfoName;
        QVariantList pfoNum;
        QVariantList pfoDesc;
        QVariantList pfoIsYahoo;
    };

    pfoModelType pfoModel;
    QVariantList posSymbol;
    QVariantList posExg;
    QVariantList posShare;
    QVariantList posCost;
    QVariantList posStop;

    //QString cfgDir;
};

#endif // FILEHANDLER_H
