import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480

    property bool txtSmooth: true
    property color backgroundColor: "ivory"
    property color currentItemColor: "#FFF8C6"
    property color pressColor: "#FDE688"
    property int listFontSize : 32

    property bool editMode: false
    property bool pfoLocal: false

    property int selectedIdx: 0
    property int pfoLocalIdx: 0
    property bool pfoIsYahoo: false

    signal close

    ListView {
        id: posEditView
        anchors.fill: parent
        anchors.bottomMargin: 90
        model: posModel
        delegate: posEditDelegate
        snapMode: ListView.SnapToItem
    }

    Component {
        id: posEditDelegate

        Item {
            id: posEditDelegateItem
            width: posEditView.width
            height: 70

            Rectangle {
                id: background
                x: 5; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: container.backgroundColor
                border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: nameBox
                anchors { top: background.top; left: background.left; leftMargin: 20; }

                smooth: txtSmooth
                font.bold: true
                font.pixelSize: listFontSize
                verticalAlignment: Text.AlignVCenter
                text: name
            }

            MouseArea {
                id: mouseArea
                anchors.fill: background
                onClicked: {
                    if (mouse.x > (parent.width - 40)) {
                        if (pfoLocal&editMode) {
                            fileHandler.removePos(index);
                            fileHandler.storePosAll(pfoLocalIdx);
                            posModel.remove(index);

                            // Jump to previous item
                            selectedIdx = (selectedIdx>0) ? selectedIdx-1 : 0;
                            posEditDelegateItem.ListView.view.currentIndex = selectedIdx;
                        }
                    }
                    else {
                        selectedIdx = index;
                        posEditDelegateItem.ListView.view.currentIndex = index;

                        reloadEditDialog(name, exchange, share, shareCost, pfoIsYahoo);
                        container.state = "entryUpdate";
                    }
                }
            }

            SimpleRect {
                id: deleteBox
                anchors { right: background.right; rightMargin: 10; }
                anchors.verticalCenter: background.verticalCenter
                width: 30
                color: "#FF5555"

                visible: (pfoLocal&editMode)

                text: "X"
                textColor: (pfoLocal&editMode) ? "white" : "grey"
                textSize: listFontSize
                radius: 10
           }

            states: [
                State {
                    name: "Pressed"
                    when: mouseArea.pressed
                    PropertyChanges { target: background; color: container.pressColor }
                },
                State {
                    name: "highlightCurrentItem"
                    when: selectedIdx == index
                    PropertyChanges { target: background; color: container.currentItemColor }
                }
            ]
        }
    }

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 10; }
        width: 65
        height: 65
        onClicked: {
            //fileHandler.storePosAll(pfoLocalIdx);
            container.close();
        }
    }


    Fader {
        fadingOpacity: 0.6
        // Bind our visibility status with Fader show/hide states.
        state: container.state!="" ? "faded" : ""
        transitionDuration: 200
        // Use the whole available area for fading & capturing key clicks.
        anchors.fill: parent
        // Use "light" fading color.
        color: "#f5f5f5"
    }

    TextButton {
        id: storeButton
        anchors { bottom: parent.bottom; right: addButton.left; rightMargin: 20; bottomMargin: 10; }
        width: 60
        height: storeButton.width
        radius: storeButton.width

        color: "#F2F2F2"
        lightColor: "#FFFFFF"
        pressColor: storeButton.color
        visible: false

        text: "="
        textColor: "#B0D8FF"
        textSize: 60
        textBold: true

        onClicked: {
            // Save pos
            fileHandler.storePosAll(pfoLocalIdx);
            container.state = "";
        }
    }

    TextButton {
        id: addButton
        anchors { bottom: parent.bottom; right: parent.right; rightMargin: 20; bottomMargin: 10; }
        width: 60
        height: addButton.width
        radius: addButton.width

        color: "#F2F2F2"
        lightColor: "#FFFFFF"
        pressColor: addButton.color

        text: "+"
        textColor: "#B0D8FF"
        textSize: 60
        textBold: true

        onClicked: {
            resetEditDialog();
            container.state = "entry";
        }
    }

    Edit {
        id: editDialog
        state: "hidden"
        pfoMode: false
        myIsYahoo: pfoIsYahoo

        onSave: {
            if (editDialog.myName!="") {
                if (container.state=="entryUpdate") {
                    fileHandler.setPos(selectedIdx, editDialog.myName.toUpperCase(), editDialog.myExg.toUpperCase(), editDialog.myShare, editDialog.myCost, editDialog.myStop);
                    fileHandler.storePosAll(pfoLocalIdx);

                    posModel.set(selectedIdx, {
                        "name": editDialog.myName.toUpperCase(),
                        "exchange": editDialog.myExg.toUpperCase(),
                        "share": editDialog.myShare,
                        "shareCost": editDialog.myCost
                    });
                }
                else {
                    fileHandler.storePos( pfoLocalIdx, editDialog.myName.toUpperCase(), editDialog.myExg.toUpperCase(), editDialog.myShare, editDialog.myCost, editDialog.myStop);

                    posModel.append({
                        "name": editDialog.myName.toUpperCase(),
                        "exchange": editDialog.myExg.toUpperCase(),
                        "share": editDialog.myShare,
                        "shareCost": editDialog.myCost
                    });
                }
            }
            container.state="";
        }
        onCancel: { container.state = "" }
    }

    states: [
        State {
            name: "entry"
            PropertyChanges { target: editDialog; state: "shown"  }
        },
        State {
            name: "entryUpdate"
            PropertyChanges { target: editDialog; state: "shown"  }
        }
//        State {
//            name: "edit"
//            PropertyChanges { target: storeButton; visible: true  }
//            PropertyChanges { target: container; editMode: true  }
//        }
    ]

    function resetEditDialog() {
        editDialog.myName   = "";
        editDialog.myExg    = "";
        editDialog.myShare  = "";
        editDialog.myCost   = "";
        //editDialog.myIsYahoo = "";
    }

    function reloadEditDialog(name, exchange, share, cost, isYahoo) {
        editDialog.myName   = name;
        editDialog.myExg    = exchange;
        editDialog.myShare  = share;
        editDialog.myCost   = cost;
        editDialog.myIsYahoo = isYahoo;
    }
}
