import QtQuick 1.0

Rectangle {
    id: container
    width: 640
    height: 480
    color: "#B0D8FF"  //"brown"

    property bool txtSmooth: true
    property color statColor: "#595454"
    property real statTopMargin: 0
    property real listFontSize : 48
    property real fontSize1: listFontSize - 7
    property real fontSize2: listFontSize - 25
    property real fontSize3: listFontSize - 23

    property bool usePortfolioView: false
    property real selectedIdx: -1
    property string chartView: ""
    property alias contentHeight: posView.contentHeight

    property bool isLandscape: ( width > height )

    signal inNewsView
    signal inStatsView
    signal inMainView

    // Portrait detail windows
    Rectangle {
        id: portraitDetail
        anchors.fill: parent
        color: "ivory"
        opacity: 0

        Text {
            id: symbolBox
            anchors { left: parent.left; leftMargin: 10 }

            smooth: txtSmooth
            font.bold: true
            font.pixelSize: listFontSize
            text: posView.model.get(posView.currentIndex).name
        }

        Text {
            id: priceBox
            anchors { top: parent.top; left: symbolBox.right; leftMargin: 20; rightMargin: 5; topMargin: 5 }

            smooth: txtSmooth
            font.pixelSize: fontSize1
            text: posView.model.get(posView.currentIndex).quotePrice
        }

        Text {
            id: gainBox
            anchors { top: priceBox.bottom; left: parent.left; leftMargin: 10; rightMargin: 5; topMargin: 5 }

            smooth: txtSmooth
            color: posView.model.get(posView.currentIndex).quoteChgColor
            font.pixelSize: fontSize1
            text: posView.model.get(posView.currentIndex).quoteChg + " (" + posView.model.get(posView.currentIndex).quoteChgPtg + "%)"
        }

        Text {
            id: askBidBox
            anchors { top: gainBox.bottom; left: parent.left; leftMargin: 10; rightMargin: 5; topMargin: 10 }

            smooth: txtSmooth
            color: statColor
            font.pixelSize: fontSize3 + 2
            text: "Ask: " + posView.model.get(posView.currentIndex).quoteAsk + " / Bid: " + posView.model.get(posView.currentIndex).quoteBid
        }

        Text {
            id: infoBox
            anchors { top: parent.top; right: parent.right; rightMargin: 10; topMargin: statTopMargin}

            smooth: txtSmooth
            color: statColor
            font.pixelSize: fontSize3
            horizontalAlignment: Text.AlignRight
            text: ("Share: " + posView.model.get(posView.currentIndex).share + "\nCostEst: " + posView.model.get(posView.currentIndex).shareCostEst + "\nValue: " + posView.model.get(posView.currentIndex).shareValue + "\nGain: " + posView.model.get(posView.currentIndex).gainPercent + "%\nYTD: " + posView.model.get(posView.currentIndex).rtnYTD + "%")
        }

        Flickable {
            id: detailFlick
            //anchors.fill: parent
            anchors { top: infoBox.bottom; left: parent.left; right: parent.right; bottom: parent.bottom }
            anchors { bottomMargin: 10; leftMargin: 10; rightMargin: 10 }
            anchors.topMargin: 10
            contentHeight: (chartView == "") ? 500 : 750 // chart.width
            clip: true

            // Line separator
            Rectangle {
                id: separator1
                anchors { top: parent.top; }
                width: parent.width
                height: 2
                color: "#D5D5D5"
            }

            Text {
                id: detailSymText;
                anchors { left: separator1.left; top: separator1.bottom; topMargin: 10 }
                wrapMode: Text.WordWrap;
                color: statColor
                font.pixelSize: fontSize3
                text: posView.model.get(posView.currentIndex).exchange + " - " + posView.model.get(posView.currentIndex).fullName;
            }

            SimpleButton {
                id: newsButton
                anchors { left: detailSymText.left; top: detailSymText.bottom; topMargin: 10 }
                text: "Related News"
                textSize: fontSize3

                onClicked: {
                    newsView.activeFeedUrl = "http://www.google.com/finance/company_news?q=" + posView.model.get(posView.currentIndex).exchange + ":" + posView.model.get(posView.currentIndex).name + "&output=rss";
                    container.inNewsView();
                }
            }

            Text {
                id: detailRangeText;
                anchors { top: newsButton.bottom; left: parent.left; topMargin: 10;  }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "Day High: " + posView.model.get(posView.currentIndex).quoteDayHi + "\nDay Low: " + posView.model.get(posView.currentIndex).quoteDayLo + "\n52w High: " + posView.model.get(posView.currentIndex).quote52wHi + "\n52w Low: " + posView.model.get(posView.currentIndex).quote52wLo + "\nMkt Cap: " + posView.model.get(posView.currentIndex).quoteMktCap;

            }

            Text {
                id: detailStatsText;
                anchors { top: newsButton.bottom; right: parent.right; topMargin: 10; }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "EPS: " + posView.model.get(posView.currentIndex).quoteEps + "\nPE: " + posView.model.get(posView.currentIndex).quotePe + "\nBeta: " + posView.model.get(posView.currentIndex).quoteBeta + "\nVol: " + posView.model.get(posView.currentIndex).quoteVol + "\nAvg Vol: " + posView.model.get(posView.currentIndex).quoteAvgVol;

            }

            // Line separator
            Rectangle {
                id: separator3
                anchors { top: detailStatsText.bottom; topMargin: 10 }
                width: parent.width
                height: 2
                color: "#D5D5D5"
            }

            SimpleButton{
                id: chartSel1
                width: (parent.width - 20)/5
                anchors { top: separator3.bottom; topMargin: 10 }
                text: "3m"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "3m";
                }
            }
            SimpleButton{
                id: chartSel2
                width: (parent.width - 20)/5
                anchors { top: separator3.bottom; left: chartSel1.right; topMargin: 10; leftMargin: 5 }
                text: "6m"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "6m";
                }
            }
            SimpleButton{
                id: chartSel3
                width: (parent.width - 20)/5
                anchors { top: separator3.bottom; left: chartSel2.right; topMargin: 10; leftMargin: 5 }
                text: "1y"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "1y";
                }
            }
            SimpleButton{
                id: chartSel4
                width: (parent.width - 20)/5
                anchors { top: separator3.bottom; left: chartSel3.right; topMargin: 10; leftMargin: 5 }
                text: "2y"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "2y";
                }
            }
            SimpleButton{
                id: chartSel5
                width: (parent.width - 20)/5
                anchors { top: separator3.bottom; left: chartSel4.right; right: separator3.right; topMargin: 10; leftMargin: 5 }
                text: "5y"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "5y";
                    console.log(parent.width);
                }
            }

            ProgressBar {
                id: chartProgress
                width: parent.width
                height: 10
                anchors { top: chartSel1.bottom; topMargin: 5; }
                anchors.horizontalCenter: parent.horizontalCenter
                barColor: "#2954FF"
                bgColor: "#2954FF"

                progress: chart.progress

                states: State {
                    name: "hideProgress"
                    when: (chart.status!=Image.Loading)
                    PropertyChanges { target: chartProgress; opacity: 0 }
                }
            }

            // Helper: http://developer.qt.nokia.com/forums/viewthread/5639
            Item {
                id: chartItem
                anchors { top: chartSel1.bottom; topMargin: 20; }
                anchors.horizontalCenter: parent.horizontalCenter

                Image {
                    id: chart
                    anchors.horizontalCenter: parent.horizontalCenter

                    width: 512
                    height: 288
                    source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/c/" + chartView + "/s/" + posView.model.get(posView.currentIndex).name
                }
            }
//            MouseArea {
//                id: detailMouseArea
//                anchors.fill: portraitDetail
//                onClicked: {
//                    chartView = "";
//                    container.state='';
//                    container.inMainView();
//                }
//            }
        }
    }

    // Landscape detail windows
    Rectangle {
        id: landscapeDetail
        anchors.fill: parent
        color: "ivory"
        opacity: 0

        Text {
            id: symbolBoxLs
            anchors { left: parent.left; leftMargin: 10; topMargin: 10 }

            smooth: txtSmooth
            font.bold: true
            font.pixelSize: listFontSize
            text: posView.model.get(posView.currentIndex).name
        }

        Text {
            id: priceBoxLs
            anchors { top: parent.top; left: symbolBoxLs.right; leftMargin: 10; rightMargin: 10; topMargin: 5 }

            smooth: txtSmooth
            font.pixelSize: fontSize1
            text: posView.model.get(posView.currentIndex).quotePrice
        }

        Text {
            id: gainBoxLs
            anchors { top: priceBoxLs.bottom; left: parent.left; leftMargin: 10; rightMargin: 10; topMargin: 5 }

            smooth: txtSmooth
            color: posView.model.get(posView.currentIndex).quoteChgColor
            font.pixelSize: fontSize1
            text: posView.model.get(posView.currentIndex).quoteChg + " (" + posView.model.get(posView.currentIndex).quoteChgPtg + "%)"
        }

        Text {
            id: askBidBoxLs
            anchors { top: gainBoxLs.bottom; left: parent.left; leftMargin: 20; rightMargin: 10; topMargin: 5 }

            smooth: txtSmooth
            color: statColor
            font.pixelSize: fontSize3 + 2
            text: "Ask: " + posView.model.get(posView.currentIndex).quoteAsk + "\nBid: " + posView.model.get(posView.currentIndex).quoteBid
        }

        Rectangle {
            id: separator0Ls
            anchors { top: askBidBoxLs.bottom; left: parent.left; topMargin: 5; bottomMargin: 5; leftMargin: 10 }
            width: gainBoxLs.width
            height: 2
            color: "#D5D5D5"
        }

        Text {
            id: infoBoxLs
            anchors { top: separator0Ls.bottom; left: parent.left; leftMargin: 20; rightMargin: 10; topMargin: 5}

            smooth: txtSmooth
            color: statColor
            font.pixelSize: fontSize3
            //horizontalAlignment: Text.AlignRight
            text: ("Share: " + posView.model.get(posView.currentIndex).share + "\nCostEst: " + posView.model.get(posView.currentIndex).shareCostEst + "\nValue: " + posView.model.get(posView.currentIndex).shareValue + "\nGain: " + posView.model.get(posView.currentIndex).gainPercent + "%\nYTD: " + posView.model.get(posView.currentIndex).rtnYTD + "%")
        }

//        Rectangle {
//            id: separator1Ls
//            anchors { top: parent.top; left: gainBoxLs.right; bottom: parent.bottom; leftMargin: 5; rightMargin: 5 }
//            width: 2
//            //height: 2
//            color: "#D5D5D5"
//        }

        Flickable {
            id: detailFlickLs
            //anchors.fill: parent
            //anchors { top: parent.top; left: separator1Ls.right; right: parent.right; bottom: parent.bottom }
            anchors { top: parent.top; left: gainBoxLs.right; right: parent.right; bottom: parent.bottom }
            anchors { bottomMargin: 10; leftMargin: 10; rightMargin: 10; }
            contentHeight: (chartView == "") ? 500 : 700 // chart.width
            clip: true

            // Line separator
            Text {
                id: detailSymTextLs;
                anchors { left: parent.left; top: parent.top; }
                wrapMode: Text.WordWrap;
                color: statColor
                font.pixelSize: fontSize3
                text: posView.model.get(posView.currentIndex).exchange + " - " + posView.model.get(posView.currentIndex).fullName;
            }

            SimpleButton {
                id: newsButtonLs
                anchors { left: detailSymTextLs.left; top: detailSymTextLs.bottom; topMargin: 10 }
                text: "Related News"
                textSize: fontSize3

                onClicked: {
                    newsView.activeFeedUrl = "http://www.google.com/finance/company_news?q=" + posView.model.get(posView.currentIndex).exchange + ":" + posView.model.get(posView.currentIndex).name + "&output=rss";
                    container.inNewsView();
                }
            }

            Text {
                id: detailRangeTextLs;
                anchors { top: newsButtonLs.bottom; left: parent.left; topMargin: 10;  }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "Day High: " + posView.model.get(posView.currentIndex).quoteDayHi + "\nDay Low: " + posView.model.get(posView.currentIndex).quoteDayLo + "\n52w High: " + posView.model.get(posView.currentIndex).quote52wHi + "\n52w Low: " + posView.model.get(posView.currentIndex).quote52wLo + "\nMkt Cap: " + posView.model.get(posView.currentIndex).quoteMktCap;

            }

            Text {
                id: detailStatsTextLs;
                anchors { top: newsButtonLs.bottom; right: parent.right; topMargin: 10; }
                color: statColor
                wrapMode: Text.WordWrap;
                font.pixelSize: fontSize3
                text: "EPS: " + posView.model.get(posView.currentIndex).quoteEps + "\nPE: " + posView.model.get(posView.currentIndex).quotePe + "\nBeta: " + posView.model.get(posView.currentIndex).quoteBeta + "\nVol: " + posView.model.get(posView.currentIndex).quoteVol + "\nAvg Vol: " + posView.model.get(posView.currentIndex).quoteAvgVol;

            }

            // Line separator
            Rectangle {
                id: separator3Ls
                anchors { top: detailStatsTextLs.bottom; topMargin: 10 }
                width: parent.width
                height: 2
                color: "#D5D5D5"
            }

            SimpleButton{
                id: chartSel1Ls
                width: (parent.width - 20)/5
                anchors { top: separator3Ls.bottom; topMargin: 10 }
                text: "3m"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "3m";
                }
            }
            SimpleButton{
                id: chartSel2Ls
                width: (parent.width - 20)/5
                anchors { top: separator3Ls.bottom; left: chartSel1Ls.right; topMargin: 10; leftMargin: 5 }
                text: "6m"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "6m";
                }
            }
            SimpleButton{
                id: chartSel3Ls
                width: (parent.width - 20)/5
                anchors { top: separator3Ls.bottom; left: chartSel2Ls.right; topMargin: 10; leftMargin: 5 }
                text: "1y"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "1y";
                }
            }
            SimpleButton{
                id: chartSel4Ls
                width: (parent.width - 20)/5
                anchors { top: separator3Ls.bottom; left: chartSel3Ls.right; topMargin: 10; leftMargin: 5 }
                text: "2y"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "2y";
                }
            }
            SimpleButton{
                id: chartSel5Ls
                width: (parent.width - 20)/5
                anchors { top: separator3Ls.bottom; left: chartSel4Ls.right; right: separator3Ls.right; topMargin: 10; leftMargin: 5 }
                text: "5y"
                textSize: fontSize2

                onClicked: {
                    container.chartView = "5y";
                    console.log(parent.width);
                }
            }

            ProgressBar {
                id: chartProgressLs
                width: parent.width
                height: 10
                anchors { top: chartSel1Ls.bottom; topMargin: 5; }
                anchors.horizontalCenter: parent.horizontalCenter
                barColor: "#2954FF"
                bgColor: "#2954FF"

                progress: chart.progress

                states: State {
                    name: "hideProgress"
                    when: (chart.status!=Image.Loading)
                    PropertyChanges { target: chartProgressLs; opacity: 0 }
                }
            }

            // Helper: http://developer.qt.nokia.com/forums/viewthread/5639
            Item {
                id: chartItemLs
                anchors { top: chartSel1Ls.bottom; topMargin: 20; }
                anchors.horizontalCenter: parent.horizontalCenter

                Image {
                    id: chartLs
                    anchors.horizontalCenter: parent.horizontalCenter

                    width: 512
                    height: 288
                    source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/c/" + chartView + "/s/" + posView.model.get(posView.currentIndex).name
                }
            }
//            MouseArea {
//                id: detailMouseArea
//                anchors.fill: portraitDetail
//                onClicked: {
//                    chartView = "";
//                    container.state='';
//                    container.inMainView();
//                }
//            }
        }
    }

    ListView {
        id: posView
        anchors.fill: parent
        model: posModel
        delegate: posDelegate
        snapMode: ListView.SnapToItem
        focus: true
    }

    Component {
        id:posDelegate

        Item {
            id: posDelegateItem
            width: posView.width
            height: 150

            property real detailOpacity: 0

            Rectangle {
                id: background
                x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: "ivory"
                border.color: "#3577B9" //"orange"
                radius: 5
            }

            Text {
                id: symbolBox
                anchors { left: background.left; leftMargin: 10 }

                smooth: txtSmooth
                font.bold: true
                font.pixelSize: listFontSize
                text: name
            }

            Text {
                id: priceBox
                anchors { top: background.top; left: symbolBox.right; leftMargin: 20; rightMargin: 5; topMargin: 5 }

                smooth: txtSmooth
                font.pixelSize: fontSize1
                text: quotePrice
            }

            Text {
                id: gainBox
                anchors { top: priceBox.bottom; left: background.left; leftMargin: 10; rightMargin: 5; topMargin: 5 }

                smooth: txtSmooth
                color: quoteChgColor
                font.pixelSize: fontSize1
                text: quoteChg + " (" + quoteChgPtg + "%)"
            }

//            Text {
//                id: askBidBox
//                anchors { top: gainBox.bottom; left: background.left; leftMargin: 10; rightMargin: 5; topMargin: 5 }

//                smooth: txtSmooth
//                font.pixelSize: fontSize1
//                text: "Ask: " + quoteAsk + "/Bid: " + quoteBid
//            }

            Image {
                id: upDownArrow
                anchors { top: gainBox.bottom; left: background.left; leftMargin: 10; }

                width: 30
                height: 30
                source: "gfx/rnd_br_down.png"
                smooth: txtSmooth
            }

            Text {
                id: infoBox
                anchors { top: background.top; right: background.right; rightMargin: 10; topMargin: statTopMargin}

                smooth: txtSmooth
                color: statColor
                font.pixelSize: fontSize2
                horizontalAlignment: Text.AlignRight
                text: usePortfolioView ? ("Share: " + share + "\nCostEst: " + shareCostEst + "\nValue: " + shareValue + "\nGain: " + gainPercent + "%\nYTD: " + rtnYTD + "%") :
                ("High: " + quoteDayHi + "\nLow: " + quoteDayLo + "\nAsk: " + quoteAsk + "\nBid: " + quoteBid + "\nVol: " + quoteVol)
            }

            MouseArea {
                id: posMouseArea
                anchors.fill: background
                onClicked: {
                    selectedIdx = index;
                    posDelegateItem.ListView.view.currentIndex = index

                    container.state = 'details';
                    container.inStatsView();
                }
            }

            // UX on N900 is unacceptable, disabled for now.
            /*
            Item {
                id: details
                x: 20; width: parent.width - 2*x
                anchors { top: infoBox.bottom; topMargin: 10; bottom: parent.bottom; bottomMargin: 10 }
                opacity: posDelegateItem.detailOpacity

                // Line separator
                Rectangle {
                    id: separator
                    width: parent.width
                    height: 2
                    color: "#D5D5D5"
                }

                // Flickable area to display detail info
                Flickable {
                    id: flick
                    width: parent.width
                    //height: parent.height
                    anchors { top: separator.bottom; bottom: parent.bottom; topMargin: 10 }
                    contentHeight: 700 // chart.width
                    clip: true

                    Text {
                        id: detailSymText;
                        wrapMode: Text.WordWrap;
                        font.pixelSize: fontSize3
                        text: quoteType + ": " + fullName + "\nExchange: " + exchange;
                    }

                    SimpleButton {
                        id: newsButton
                        anchors { left: detailSymText.left; top: detailSymText.bottom; topMargin: 10 }
                        text: "Related News"
                        textSize: fontSize3

                        onClicked: {
                            newsView.activeFeedUrl = "http://www.google.com/finance/company_news?q=" + exchange + ":" + name + "&output=rss";
                            container.inNewsView();
                        }
                    }

                    // Line separator
                    Rectangle {
                        id: separator2
                        anchors { top: newsButton.bottom; topMargin: 10 }
                        width: separator.width
                        height: 2
                        color: "#D5D5D5"
                    }

                    Text {
                        id: detailRangeText;
                        anchors { top: separator2.bottom; left: parent.left; topMargin: 10;  }
                        wrapMode: Text.WordWrap;
                        font.pixelSize: fontSize3
                        text: "Day High: " + quoteDayHi + "\nDay Low: " + quoteDayLo + "\n52w High: " + quote52wHi + "\n52w Low: " + quote52wLo + "\nAvg Vol: " + quoteAvgVol;

                    }

                    Text {
                        id: detailStatsText;
                        anchors { top: separator2.bottom; right: parent.right; topMargin: 10; }
                        wrapMode: Text.WordWrap;
                        font.pixelSize: fontSize3
                        text: "Mkt Cap: " + quoteMktCap + "\nEPS: " + quoteEps + "\nPE: " + quotePe + "\nBeta: " + quoteBeta + "\nVol: " + quoteVol;

                    }

                    // Line separator
                    Rectangle {
                        id: separator3
                        anchors { top: detailStatsText.bottom; topMargin: 10 }
                        width: separator.width
                        height: 2
                        color: "#D5D5D5"
                    }

                    SimpleButton{
                        id: chartSel1
                        width: parent.width/6
                        anchors { top: separator3.bottom; left: parent.left; topMargin: 10 }
                        text: "3m"
                        textSize: fontSize2

                        onClicked: {
                            container.chartView = "3m";
                        }
                    }
                    SimpleButton{
                        id: chartSel2
                        width: parent.width/6
                        anchors { top: separator3.bottom; left: chartSel1.right; topMargin: 10; leftMargin: 5 }
                        text: "6m"
                        textSize: fontSize2

                        onClicked: {
                            container.chartView = "6m";
                        }
                    }
                    SimpleButton{
                        id: chartSel3
                        width: parent.width/6
                        anchors { top: separator3.bottom; left: chartSel2.right; topMargin: 10; leftMargin: 5 }
                        text: "1y"
                        textSize: fontSize2

                        onClicked: {
                            container.chartView = "1y";
                        }
                    }
                    SimpleButton{
                        id: chartSel4
                        width: parent.width/6
                        anchors { top: separator3.bottom; left: chartSel3.right; topMargin: 10; leftMargin: 5 }
                        text: "2y"
                        textSize: fontSize2

                        onClicked: {
                            container.chartView = "2y";
                        }
                    }
                    SimpleButton{
                        id: chartSel5
                        width: parent.width/6
                        anchors { top: separator3.bottom; left: chartSel4.right; topMargin: 10; leftMargin: 5 }
                        text: "5y"
                        textSize: fontSize2

                        onClicked: {
                            container.chartView = "5y";
                        }
                    }

                    ProgressBar {
                        id: chartProgress
                        width: 470
                        height: 10
                        anchors { top: chartSel1.bottom; left: parent.left; topMargin: 0; }

                        progress: chart.progress

                        states: State {
                            name: "hideProgress"
                            when: (chart.status!=Image.Loading)
                            PropertyChanges { target: chartProgress; opacity: 0 }
                        }

                    }

                    // Helper: http://developer.qt.nokia.com/forums/viewthread/5639
                    Item {
                        id: chartItem
                        anchors { top: chartSel1.bottom; topMargin: 10; }

                        Image {
                            id: chart

                            sourceSize.width: 512
                            sourceSize.height: 288
                            source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/c/" + chartView + "/s/" + name
                        }
                    }

                }
            }

            states: State {
                name: "details"

                PropertyChanges { target: upDownArrow; source: "gfx/rnd_br_up.png" }
                // Force to portfolio view
                PropertyChanges { target: container; usePortfolioView: true }
                PropertyChanges { target: background; color: "white" }
                // Make details visible
                PropertyChanges { target: posDelegateItem; detailOpacity: 1; }
                // Fill the entire list area with the detailed view
                PropertyChanges { target: posDelegateItem; height: posView.height }

                // Disallow flicking while we're in detailed view
                PropertyChanges { target: posDelegateItem.ListView.view; interactive: false }

                // Move the list so that this item is at the top.
                StateChangeScript {
                    name: "detailView"
                    script: {
                        // Available after QtQuick 1.1
                        //posDelegateItem.ListView.view.positionViewAtBeginning();
                        posDelegateItem.ListView.view.positionViewAtIndex(index, ListView.Beginning);
                    }
                }

            }

            transitions: Transition {
                // Make the state changes smooth
                ParallelAnimation {
                    //ColorAnimation { property: "color"; duration: 500; }
                    NumberAnimation { properties: "usePortfolioView"; duration: 100;  }
                    NumberAnimation { properties: "x,contentY,height"; duration: 300;  }
                    //SmoothedAnimation { properties: "x,contentY,height"; duration: 300;  }
                }
            }
            */
        }
    }

    states: State {
        name: "details"

        PropertyChanges { target: portraitDetail; opacity: !isLandscape  }
        PropertyChanges { target: landscapeDetail; opacity: isLandscape  }
        PropertyChanges { target: posView; opacity: 0  }
        PropertyChanges { target: backButton; opacity: 1  }
        // Change color to avoid flash in transition from default to details
        PropertyChanges { target: container; color: "ivory"  }
    }

    transitions: [
        Transition {
            ParallelAnimation {
                PropertyAnimation { target: portraitDetail; properties: "opacity"; duration: 130}
                PropertyAnimation { target: posView; properties: "opacity"; duration: 130}
                PropertyAnimation { target: backButton; properties: "opacity"; duration: 130}
                // Animate color change to reduce flash in transition from details to default
                PropertyAnimation { target: container; properties: "color"; from: "ivory"; duration: 130}
            }
        }
    ]

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 20; }
        opacity: 0
        focus: true
        width: 65
        height: 65
        onClicked: {
            chartView = "";
            container.state='';
            container.inMainView();
        }
    }
}


