import QtQuick 1.0

Item {
    anchors.fill: parent
    width: 640
    height: 480

    Image {
        id: aboutImg
        anchors.centerIn: parent
        anchors.verticalCenterOffset: - parent.height/3
        source: "gfx/stockona.png"
        width: 48
        height: 48
        smooth: true
    }

    Text {
        id: aboutTitle
        anchors { top: aboutImg.bottom; horizontalCenter: parent.horizontalCenter; topMargin: 10 }
        text: "<b>stockona</b>"
        font.pixelSize: 28
        horizontalAlignment: Text.AlignHCenter
    }

    Text {
        id: aboutVersion
        anchors { top: aboutTitle.bottom; horizontalCenter: parent.horizontalCenter; topMargin: 10 }
        text: "version 0.0.11"
        font.pixelSize: 22
        horizontalAlignment: Text.AlignHCenter
    }
    Text {
        id: aboutTxt
        anchors { top: aboutVersion.bottom; topMargin: 40; left: parent.left; right: parent.right; leftMargin: 20; rightMargin: 20}
        text: "Stockona is a free google finance client under GNU license.<br><a href='http://projects.forum.nokia.com/stockona'>http://projects.forum.nokia.com/stockona</a><br><br>Credits go to:<br>Tommi Laukkanen<br>MaeMoney, StockThis<br>Nokia QT team"
        font.pixelSize: 22
        horizontalAlignment: Text.AlignHCenter
        wrapMode: Text.WordWrap
    }
}
