import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480

    property bool txtSmooth: true
    property color backgroundColor: "ivory"
    property color currentItemColor: "#FFF8C6"
    property color pressColor: "#FDE688"
    property real listFontSize : 32
    property string activePos: "http://finance.google.com/finance/feeds/default/portfolios/1/positions"
    property real selectedIdx: 0
    property string activePosTitle: pfoView.model.get(pfoView.currentIndex).name

    signal close
    signal update

    ListView {
        id: pfoView
        anchors.fill: parent
        model: pfoModel
        delegate: pfoDelegate
        focus: true
        snapMode: ListView.SnapToItem
    }

    Component {
        id: pfoDelegate

        Item {
            id: pfoDelegateItem
            width: pfoView.width
            height: 70

            Rectangle {
                id: background
                x: 5; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: container.backgroundColor
                border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: nameBox
                anchors { top: background.top; left: background.left; leftMargin: 20; }//verticalCenter: parent.verticalCenter }

                smooth: txtSmooth
                font.bold: true
                font.pixelSize: listFontSize
                //verticalAlignment: Text.AlignVCenter
                text: name
            }

            Text {
                id: excerptBox
                anchors { top: nameBox.bottom; left: background.left; leftMargin: 40; }//verticalCenter: parent.verticalCenter }

                smooth: txtSmooth
                color: "#808080"
                font.pixelSize: listFontSize - 14
                //verticalAlignment: Text.AlignVCenter
                text: excerpt
            }

            Text {
                id: countBoxHidden
                visible: false
                text: num
            }

            SimpleButton {
                id: countBox
                anchors { right: background.right; rightMargin: 10; }
                anchors.verticalCenter: background.verticalCenter
                width: countBoxHidden.width+20 //(countBoxHidden.width<50) ? 50 : countBoxHidden.width + 20
                color: "#E0ECF7"
                text: num
                textColor: "grey"
                textSize: listFontSize
                radius: 10
           }

            MouseArea {
                id: mouseArea
                anchors.fill: background
                onClicked: {
                    activePos = feedLink;
                    console.log(activePos);
                    selectedIdx = index;
                    pfoDelegateItem.ListView.view.currentIndex = index;

                    container.update();
                }
            }

            states: [
                State {
                    name: "Pressed"
                    when: mouseArea.pressed
                    PropertyChanges { target: background; color: container.pressColor }
                    //StateChangeScript { name: "DBG"; script: { console.log(selectedIdx); } }
                },
                State {
                    name: "highlightCurrentItem"
                    when: selectedIdx == index
                    PropertyChanges { target: background; color: container.currentItemColor }
                }
            ]
        }
    }
    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 20; }
        focus: true
        width: 65
        height: 65
        onClicked: { container.close(); }
    }
}
