import QtQuick 1.0

Rectangle {
    id: container
    color: "#7DBFFF" //#CDDAE6"
    width: 640
    height: 40

    property alias text: headerTxt.text
    property alias showBusy: waitIndicator.show

    Item {
        id: minimizeButton
        anchors { top: parent.top; left: parent.left; leftMargin: 10; topMargin: 0 }
        width: parent.height
        height: parent.height

        Image {
            anchors.centerIn: parent
            smooth: true
            source: "gfx/minimizeicon.png"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: {
                console.log("Minimizing");
                windowHelper.minimize();
            }
        }
    }

    Rectangle {
        id: separator1
        anchors { left: minimizeButton.right; top: parent.top; leftMargin: 10; topMargin: 2 }
        color: "#B9DCFF"
        height: parent.height - 4
        width: 2
        radius: 2
    }

    Text {
        id: headerTxt
        width: parent.width - 160
        anchors.centerIn: parent
        font.bold: true
        color: "white"
        clip: true
        horizontalAlignment: Text.AlignHCenter

        font.pixelSize: 28
        elide: Text.ElideRight
    }

    WaitIndicator {
        id: waitIndicator
        anchors { right: separator2.left; rightMargin: 20; }
        anchors { verticalCenter: parent.verticalCenter; }

        width: parent.height - 18
        height: parent.height - 18
        imageHeight: parent.height - 18
        imageWidth: parent.height - 18

        //show: mainWindow.showWaitIndicator
        //anchors.fill: parent
    }

    Rectangle {
        id: separator2
        anchors { right: quitButton.left; top: parent.top; rightMargin: 10; topMargin: 2 }
        color: "#B9DCFF"
        height: parent.height - 4
        width: 2
        radius: 2
    }

    Item {
        id: quitButton
        anchors { top: parent.top; right: parent.right; rightMargin: 10; topMargin: 0 }
        height: parent.height
        width: parent.height

        Image {
            // x.png is slightly above center
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            anchors.verticalCenterOffset: 1

            //anchors { top: parent.top; right: parent.right; topMargin: 1 }
            smooth: true
            source: "gfx/x.png"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: {
                console.log("Exiting");
                Qt.quit();
            }
        }
    }
}
