from PyQt4.QtGui import QStyledItemDelegate
from PyQt4.Qt import QFont, Qt, QStyleOptionViewItemV4, QRect, QSize
from StockMatch import *

class StockMatchTableDelegate(QStyledItemDelegate):


    def sizeHint(self, option, index):
        line1 = index.data(Qt.DisplayRole).toString()

        textW = option.fontMetrics.width(line1)

        lineSpacing = option.fontMetrics.lineSpacing()
        numLines = 2
        delta = 10
        hint = QSize(textW + delta, numLines * lineSpacing + delta)

        return hint

    def paint (self, painter, option, index):
        '''
        @param painter QPainter
        @param option    QStyleOptionViewItem
        @param index   QModelIndex
        '''

        if index.column() is StockMatchTableModel.COL_NAME:
           # Name column
            
            painter.save()

            m = index.model()
            line1 = m.data(index, Qt.DisplayRole).toString()
            line2 = m.data(index, StockMatchTableModel.ROLE_SUBTEXT1).toString()

            itemRect = option.rect
            lineSp = option.fontMetrics.lineSpacing()
            numLines = 2
            subTextColor = painter.pen().color()
            subTextColor.setAlphaF(0.5)

            textRect = QRect(itemRect.left(), itemRect.bottom() - numLines * lineSp,
                             itemRect.width(), numLines * lineSp)
            painter.drawText(textRect, Qt.AlignTop | Qt.AlignLeft, line1)

            textRect.adjust(0, option.fontMetrics.lineSpacing(), 0, 0)
            painter.setPen(subTextColor)
            painter.drawText(textRect, Qt.AlignTop | Qt.AlignLeft, line2)

            painter.restore()
        else:
            QStyledItemDelegate.paint(self, painter, option, index)