# coding=utf-8

from PyQt4 import QtGui, QtCore, Qt
from PyQt4.Qt import QMainWindow, QWidget, QHBoxLayout, QVBoxLayout, \
                     QLineEdit, QPushButton, QTableView, SIGNAL, QUrl

import sys
import traceback

from StockMatchTableDelegate import StockMatchTableDelegate
from StockMatchTableModel import StockMatchTableModel
from StockMatchGoogleFinance import *

class SMMainWindow(QMainWindow):
    PROP_FINGER_SCROLLABLE = "FingerScrollable"
    

    def __init__(self):
        QMainWindow.__init__(self)
        widget = QWidget(self)
        self.setCentralWidget(widget)
        self.hbox = QHBoxLayout(widget)
        self.vbox = QVBoxLayout()
        self.hbox.addLayout(self.vbox)

        self.lineEdit = QLineEdit()
        # Qt.WA_InputMethodEnabled (14)
#        self.lineEdit.setAttribute(Qt.WA_InputMethodEnabled)
        self.lookupButton = QPushButton(u"查詢 Lookup")
        self.openUrlButton = QPushButton("Google Finance")
        self.openUrlButton.setEnabled(False)
#        self.hkCheckbox = QCheckBox(StockMatchTableModel.COUNTRY_HK)

        self.vbox.addWidget(self.lineEdit)
        self.vbox.addWidget(self.lookupButton)
        self.vbox.addWidget(self.openUrlButton)
#        self.vbox.addWidget(self.hkCheckbox)
        self.vbox.addStretch()

        self.model = StockMatchTableModel()
        self.table = QTableView()
        self.table.setModel(self.model)
        self.table.setMinimumWidth(480)
        self.table.setWordWrap(False)
        self.table.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.table.horizontalHeader().setStretchLastSection(True)
        self.table.setSelectionMode(QtGui.QTableView.SingleSelection)
        self.table.setSelectionBehavior(QtGui.QTableView.SelectRows)
        self.table.setProperty(self.PROP_FINGER_SCROLLABLE, True)

        self.delegate = StockMatchTableDelegate()
        self.table.setItemDelegate(self.delegate)

        self.stockMatcher = StockMatchGoogleFinance()
        self.hbox.addWidget(self.table)

        self.setWindowTitle(u"查股坊 Stock Matcher")

        self.connect(self.lineEdit, SIGNAL("returnPressed()"), self.lookupButton.click)
        self.connect(self.lookupButton, SIGNAL("pressed()"), self.processNewQuery)
        self.connect(self.table.selectionModel(),
                     SIGNAL("selectionChanged(QItemSelection, QItemSelection)"),
                     self.entrySelected)
        self.connect(self.openUrlButton, SIGNAL("pressed()"), self.openUrl)

    def processNewQuery(self):
        queryString = self.lineEdit.text()
        matches = self.stockMatcher.match(queryString)
        if matches is None:
            self.model.clear()
        else:
            self.model.reset(matches)
            self.table.resizeRowsToContents()
            self.table.resizeColumnsToContents()

        self.lineEdit.setFocus(True)
        self.openUrlButton.setEnabled(False)

    def entrySelected(self, selected):
        '''
        selected (type: QItemSelection) represents the selected row
        '''

        # Obtain a list of QModelIndex for the selected row
        selectedIndexes = selected.indexes()
        if len(selectedIndexes) > 0:
            # Pick the first cell (doesn't matter which column)
            # Assume SingleSelection mode
            anyCell = selectedIndexes[0]
            # Now print the ticker
            tickerSelected = self.model.getTicker(anyCell)
            if tickerSelected and tickerSelected is not None:
                self.gFinanceUrlForSelectedTicker = "http://www.google.com.hk/finance?q=%s" %(tickerSelected)
                self.openUrlButton.setText("Google Finance\n" + tickerSelected)
                self.openUrlButton.setEnabled(True)
            else:
                self.openUrlButton.setText("Google Finance")
                self.openUrlButton.setEnabled(False)
        else:
            self.openUrlButton.setText("Google Finance")
            self.openUrlButton.setEnabled(False)            

    def openUrl(self):
        import os
        if os.name == 'posix':
            os.system('dbus-send --type=method_call --dest=com.nokia.osso_browser \
                       /com/nokia/osso_browser/request \
                       com.nokia.osso_browser.open_new_window \
                       string:%s' %(self.gFinanceUrlForSelectedTicker))
        else:
            from PyQt4.Qt import QDesktopServices
            url = QUrl(self.gFinanceUrlForSelectedTicker, QUrl.TolerantMode)
            QDesktopServices.openUrl(url)

         
