#include <cstring>
#include "shacalculator.h"

#define SERIAL_LENGTH 12

#define ROTATE_LEFT(a,n)(((a)<<(n)) | (((a) & 0xffffffff)>>(32-(n))))
#define ROTATE_RIGHT(a,n) (((a)>>(n)) | (((a) & 0xffffffff)<<(32-(n))))

#define bswap(x)ROTATE_RIGHT( ( ((x & 0xFF00FF00) >> 8L) | ((x & 0x00FF00FF) << 8L) ),16L)

#define F(b,c,d)    ((((c) ^ (d)) & (b)) ^ (d))
#define G(b,c,d)    ((b) ^ (c) ^ (d))
#define H(b,c,d)    (((b) & (c)) | (((b) | (c)) & (d)))
#define I(b,c,d)    ((b) ^ (c) ^ (d))

#define sha1_ff(a,b,c,d,e,i) \
    (e) = x3_buffer.W[i] + (e) + 0x5a827999L + ROTATE_LEFT((a),5) + F((b),(c),(d)); \
    (b) = ROTATE_RIGHT((b),2);

#define sha2_gg(a,b,c,d,e,i) \
    (e) = x3_buffer.W[i] + (e) + 0x6ed9eba1L + ROTATE_LEFT((a),5) + G((b),(c),(d)); \
    (b) = ROTATE_RIGHT((b),2);

#define sha3_hh(a,b,c,d,e,i) \
    (e) = x3_buffer.W[i] + (e) + 0x8f1bbcdcL + ROTATE_LEFT((a),5) + H((b),(c),(d)); \
    (b) = ROTATE_RIGHT((b),2);

#define sha4_ii(a,b,c,d,e,i) \
    (e) = x3_buffer.W[i] + (e) + 0xca62c1d6L + ROTATE_LEFT((a),5) + I((b),(c),(d)); \
    (b) = ROTATE_RIGHT((b),2);

const unsigned char hexTable[]="0123456789ABCDEF";

#define hexmsb(x)(hexTable[((x & 0xf0) >> 4)])
#define hexlsb(x)(hexTable[ (x & 0x0f)])

ShaCalculator::ShaCalculator()
{
        init_yy();
        init_ww();
        init_xxx();
        x1_schedules = &this->xxx_schedules[0][0];
        x2_schedules = &xxx_schedules[1][0];
        x3_schedules = &xxx_schedules[2][0];
}

void ShaCalculator::expand(sha1_key *dst, sha1_key *src)
{
    for(int i = 0;i < 16;i++)
        dst->W[i] = bswap(src->W[i]);

    for(int i = 16;i < 80;i++)
        dst->W[i] = ROTATE_LEFT((dst->W[i-3] ^ dst->W[i-8] ^ dst->W[i-14] ^ dst->W[i-16]),1);
}

void ShaCalculator::init_yy(void)
{
    unsigned char buffer[64]={0};

    for(int year = 4;year <= 9;year++) {

        memset(buffer,0,sizeof(buffer));

        buffer[0] = 'C';
        buffer[1] = 'P';
        buffer[2] = '0';

        buffer[SERIAL_LENGTH] = 0x80;
        ((unsigned long*)buffer)[15] = bswap(SERIAL_LENGTH * 8);

        buffer[3] = year + '0';
        expand(&yy_schedules[year-4],(sha1_key*)buffer);
    }
}

void ShaCalculator::init_ww(void)
{
    unsigned char buffer[64]={0};

    for(int week = 1;week <= 52;week++)
    {
        memset(buffer,0,sizeof(buffer));

        buffer[4] = (week / 10) + '0';
        buffer[5] = (week % 10) + '0';

        expand(&ww_schedules[week-1],(sha1_key*)buffer);
    }
}

void ShaCalculator::init_xxx(void)
{
    unsigned char buffer[64];

    for(int i = 0;i < 3;i++)
    {
        for(int x1 = 0;x1 < 36;x1++)
        {
            memset(buffer,0,sizeof(buffer));

            buffer[2*i+6] = hexmsb(charTable[x1]);;
            buffer[2*i+7] = hexlsb(charTable[x1]);;

            expand(&xxx_schedules[i][x1],(sha1_key*)buffer);
        }
    }
}



void ShaCalculator::sha1_block(void)
{
    register unsigned long a,b,c,d,e;

    a = (unsigned long)0x67452301L;
    b = (unsigned long)0xefcdab89L;
    c = (unsigned long)0x98badcfeL;
    d = (unsigned long)0x10325476L;
    e = (unsigned long)0xc3d2e1f0L;

    sha1_ff(a,b,c,d,e, 0);
    sha1_ff(e,a,b,c,d, 1);
    sha1_ff(d,e,a,b,c, 2);
    sha1_ff(c,d,e,a,b, 3);
    sha1_ff(b,c,d,e,a, 4);

    sha1_ff(a,b,c,d,e, 5);
    sha1_ff(e,a,b,c,d, 6);
    sha1_ff(d,e,a,b,c, 7);
    sha1_ff(c,d,e,a,b, 8);
    sha1_ff(b,c,d,e,a, 9);

    sha1_ff(a,b,c,d,e,10);
    sha1_ff(e,a,b,c,d,11);
    sha1_ff(d,e,a,b,c,12);
    sha1_ff(c,d,e,a,b,13);
    sha1_ff(b,c,d,e,a,14);

    sha1_ff(a,b,c,d,e,15);
    sha1_ff(e,a,b,c,d,16);
    sha1_ff(d,e,a,b,c,17);
    sha1_ff(c,d,e,a,b,18);
    sha1_ff(b,c,d,e,a,19);

    /* ================ */

    sha2_gg(a,b,c,d,e,20);
    sha2_gg(e,a,b,c,d,21);
    sha2_gg(d,e,a,b,c,22);
    sha2_gg(c,d,e,a,b,23);
    sha2_gg(b,c,d,e,a,24);

    sha2_gg(a,b,c,d,e,25);
    sha2_gg(e,a,b,c,d,26);
    sha2_gg(d,e,a,b,c,27);
    sha2_gg(c,d,e,a,b,28);
    sha2_gg(b,c,d,e,a,29);

    sha2_gg(a,b,c,d,e,30);
    sha2_gg(e,a,b,c,d,31);
    sha2_gg(d,e,a,b,c,32);
    sha2_gg(c,d,e,a,b,33);
    sha2_gg(b,c,d,e,a,34);

    sha2_gg(a,b,c,d,e,35);
    sha2_gg(e,a,b,c,d,36);
    sha2_gg(d,e,a,b,c,37);
    sha2_gg(c,d,e,a,b,38);
    sha2_gg(b,c,d,e,a,39);

    /* ================ */

    sha3_hh(a,b,c,d,e,40);
    sha3_hh(e,a,b,c,d,41);
    sha3_hh(d,e,a,b,c,42);
    sha3_hh(c,d,e,a,b,43);
    sha3_hh(b,c,d,e,a,44);

    sha3_hh(a,b,c,d,e,45);
    sha3_hh(e,a,b,c,d,46);
    sha3_hh(d,e,a,b,c,47);
    sha3_hh(c,d,e,a,b,48);
    sha3_hh(b,c,d,e,a,49);

    sha3_hh(a,b,c,d,e,50);
    sha3_hh(e,a,b,c,d,51);
    sha3_hh(d,e,a,b,c,52);
    sha3_hh(c,d,e,a,b,53);
    sha3_hh(b,c,d,e,a,54);

    sha3_hh(a,b,c,d,e,55);
    sha3_hh(e,a,b,c,d,56);
    sha3_hh(d,e,a,b,c,57);
    sha3_hh(c,d,e,a,b,58);
    sha3_hh(b,c,d,e,a,59);

    /* ================ */

    sha4_ii(a,b,c,d,e,60);
    sha4_ii(e,a,b,c,d,61);
    sha4_ii(d,e,a,b,c,62);
    sha4_ii(c,d,e,a,b,63);
    sha4_ii(b,c,d,e,a,64);

    sha4_ii(a,b,c,d,e,65);
    sha4_ii(e,a,b,c,d,66);
    sha4_ii(d,e,a,b,c,67);
    sha4_ii(c,d,e,a,b,68);
    sha4_ii(b,c,d,e,a,69);

    sha4_ii(a,b,c,d,e,70);
    sha4_ii(e,a,b,c,d,71);
    sha4_ii(d,e,a,b,c,72);
    sha4_ii(c,d,e,a,b,73);
    sha4_ii(b,c,d,e,a,74);

    sha4_ii(a,b,c,d,e,75);
    sha4_ii(e,a,b,c,d,76);
    sha4_ii(d,e,a,b,c,77);
    sha4_ii(c,d,e,a,b,78);
    sha4_ii(b,c,d,e,a,79);

    sha1_hash[0] = a + (unsigned long)0x67452301L;
    sha1_hash[1] = b + (unsigned long)0xefcdab89L;
    sha1_hash[2] = c + (unsigned long)0x98badcfeL;
    sha1_hash[3] = d + (unsigned long)0x10325476L;
    sha1_hash[4] = e + (unsigned long)0xc3d2e1f0L;
}
