#include <QtCore>
#include <QtGui>
#include <q-extras/qtsingleapplication.h>

#include "appeventlistener.hpp"
#include "stickynoteswidget.hpp"
#include "dialogs.hpp"

static AppEventListener *_instance = NULL;

AppEventListener* AppEventListener::instance()
{
    if (_instance == NULL)
        _instance = new AppEventListener(QCoreApplication::instance());

    return _instance;
}

AppEventListener::AppEventListener(QObject *parent) :
    QObject(parent)
{
    // Connect to the QtSingleApplication's event
    QObject::connect(QtSingleApplication::instance(), SIGNAL(messageReceived(const QString&)), this, SLOT(receiveMessage(const QString&)));
    // some time after startup, perform some initialization that can wait that long
    QTimer::singleShot(7000, this, SLOT(delayedInitialization()));
}

void AppEventListener::receiveMessage(const QString& message)
{
    if (message == APP_MESSAGE_ADDWIDGET)
    {
        StickyNotesWidget::createAndShowNew();
    }
    else if (message == APP_MESSAGE_CLOSE)
    {
        ((QApplication*)sender())->quit();
    }
}

void AppEventListener::delayedInitialization()
{
    // Initializes the singleton instance of Dialogs
    /* (Note that if the user has clicked the middle button on a note,
       it will already be initialized. Otherwise this speeds up
       its response time on the first click.) */
    Dialogs::instance();
}
