#ifndef QMAEMO5DYNAMICHOMESCREENWIDGET_H
#define QMAEMO5DYNAMICHOMESCREENWIDGET_H

#include <QtCore>
#include <QtGui>

#define WIDGET_SETTINGS_BASE_APPLETID QApplication::applicationName() + "-widget-"
#define WIDGET_SETTINGS_POSITION_X "-position-x"
#define WIDGET_SETTINGS_POSITION_Y "-position-y"
#define WIDGET_SETTINGS_HOMESCREEN_N "-homescreen-n"

class QMaemo5DynamicHomescreenWidget : public QWidget
{
    Q_OBJECT

private:

    bool _isPositionLoaded;
    bool _isPressed;
    bool _settingsDialogAvailable;
    bool _isVisibleOnCurrentHomescreen;
    bool _shouldRegister;
    int _hackSequenceForSavingFromCallback;
    int _hackSequenceCount;
    int _homescreenNumber;
    QString _appletId;

protected:

    virtual bool x11Event(XEvent *event);
    virtual void paintEvent(QPaintEvent *event);
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *event);
    virtual void showEvent(QShowEvent *event);
    virtual void closeEvent(QCloseEvent *event);
    virtual void moveEvent(QMoveEvent *event);

    virtual void showSettingsDialog();
    virtual bool restoreWidgetState();

public:

    explicit QMaemo5DynamicHomescreenWidget(bool settingsAvailable = false, QWidget *parent = 0);
    ~QMaemo5DynamicHomescreenWidget();

    QString appletId();
    void savePosition();
    void loadPosition();
    void saveSetting(const QString &key, const QVariant &data);
    QVariant loadSetting(const QString &key, const QVariant &defaultValue = QVariant());

    bool isVisibleOnCurrentHomescreen();
    bool settingsDialogAvailable();
    bool isPressed();
    bool isPositionLoaded();
    bool shouldRegister();
    void setShouldRegister(bool value);
    int homescreenNumber();
    bool restoreAppletId(const QString &appletId);

    friend class QMaemo5DynamicWidgetHelper;
};

#endif // QMAEMO5DYNAMICHOMESCREENWIDGET_H
