/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#include "StarloreDialog.hpp"
#include "MobileGui.hpp"

#include "StelModuleMgr.hpp"
#include "StelApp.hpp"
#include "StelSkyCultureMgr.hpp"
#include "StelFileMgr.hpp"
#include "StelLocaleMgr.hpp"

#include <QDebug>
#include <QFile>

StarloreDialog::StarloreDialog(QWidget* parent) : QDialog(parent)
{
	setWindowFlags(windowFlags() | Qt::Window);
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
	setupUi(this);

	culturesListWidget->blockSignals(true);
	culturesListWidget->clear();
	// qDebug() << "TEST" << StelApp::getInstance().getSkyCultureMgr().getSkyCultureListI18();

	culturesListWidget->addItems(StelApp::getInstance().getSkyCultureMgr().getSkyCultureListI18());
	culturesListWidget->setCurrentItem(culturesListWidget->findItems(StelApp::getInstance().getSkyCultureMgr().getCurrentSkyCultureNameI18(), Qt::MatchExactly).at(0));
	culturesListWidget->blockSignals(false);
	updateSkyCultureText();
	connect(culturesListWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(skyCultureChanged(QListWidgetItem*)));
}


void StarloreDialog::skyCultureChanged(QListWidgetItem* item)
{
	StelApp::getInstance().getSkyCultureMgr().setCurrentSkyCultureNameI18(item->text());
	updateSkyCultureText();
}

void StarloreDialog::updateSkyCultureText()
{
	QString descPath;
	try
	{
		descPath = StelFileMgr::findFile("skycultures/" + StelApp::getInstance().getSkyCultureMgr().getCurrentSkyCultureID() + "/description."+StelApp::getInstance().getLocaleMgr().getAppLanguage()+".utf8");
	}
	catch (std::runtime_error& e)
	{
		try
		{
			descPath = StelFileMgr::findFile("skycultures/" + StelApp::getInstance().getSkyCultureMgr().getCurrentSkyCultureID() + "/description.en.utf8");
		}
		catch (std::runtime_error& e)
		{
			qWarning() << "WARNING: can't find description for skyculture" << StelApp::getInstance().getSkyCultureMgr().getCurrentSkyCultureID();
		}
	}

	QStringList searchPaths;
	try
	{
		searchPaths << StelFileMgr::findFile("skycultures/" + StelApp::getInstance().getSkyCultureMgr().getCurrentSkyCultureID());
	}
	catch (std::runtime_error& e) {}

	skyCultureTextBrowser->setSearchPaths(searchPaths);
	
	if (descPath.isEmpty())
	{
		skyCultureTextBrowser->setHtml(q_("No description"));
	}
	else
	{
		QFile f(descPath);
		f.open(QIODevice::ReadOnly);
		skyCultureTextBrowser->setHtml(QString::fromUtf8(f.readAll()));
	}
}

