/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "SkyDialog.hpp"

#include "PlanetsDialog.hpp"
#include "AtmosphereDialog.hpp"
#include "LabelsDialog.hpp"
#include "StelTranslator.hpp"

#include <QStackedWidget>
#include <QRadioButton>
#include <QSignalMapper>

SkyDialog::SkyDialog(QWidget* parent) : QDialog(parent)
{
	setWindowTitle(q_("Sky"));
	QVBoxLayout* layout = new QVBoxLayout(this);

	QHBoxLayout* buttonsLayout = new QHBoxLayout();
	layout->addLayout(buttonsLayout);
	buttonsLayout->setSpacing(0);
	QStackedWidget* stackedWidget = new QStackedWidget; // Retrieved by addDialogTab.
	layout->addWidget(stackedWidget);
	addDialogTab(q_("Planets"), &PlanetsDialog::staticMetaObject);
	addDialogTab(q_("Atmosphere"), &AtmosphereDialog::staticMetaObject);
	addDialogTab(q_("Labels"), &LabelsDialog::staticMetaObject);
}

// Append a new dialog into the menu
//
// This takes care of creating the button in the top Layout, add the dialog into
// the QStackedWidget, and create the connection between them.
void SkyDialog::addDialogTab(const QString name, const QMetaObject* metaClass)
{
	QRadioButton *button = new QRadioButton(name);
	QLayout* buttonsLayout = layout()->itemAt(0)->layout();
	buttonsLayout->addWidget(button);
	QStackedWidget* stackedWidget = findChild<QStackedWidget*>();
	Q_ASSERT_X(stackedWidget, Q_FUNC_INFO, "The parent widget should posses a QStackedWidget");
	QWidget* dialog = qobject_cast<QWidget*>(metaClass->newInstance(Q_ARG(QWidget*, this)));
	stackedWidget->addWidget(dialog);
	QSignalMapper* signalMapper = new QSignalMapper(this);
	connect(button, SIGNAL(clicked()), signalMapper, SLOT(map()));
	signalMapper->setMapping(button, dialog);
	connect(signalMapper, SIGNAL(mapped(QWidget*)), stackedWidget, SLOT(setCurrentWidget(QWidget*)));
	// If it was the first dialog then we select it by default.
	if (stackedWidget->count() == 1)
		button->setChecked(true);
}

