/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _SEARCHDIALOG_HPP_
#define _SEARCHDIALOG_HPP_

#include "ui_SearchDialog.h"
#include "VecMath.hpp"

#include <QDialog>

class SimbadSearcher;
class SimbadLookupReply;
class StelObjectMgr;

class SearchDialog : public QDialog, private Ui_SearchDialog
{
	Q_OBJECT

public:
	Q_INVOKABLE SearchDialog(QWidget *parent=0);
	virtual ~SearchDialog();
	bool eventFilter(QObject *object, QEvent *event);

private slots:
	//! Called when the current simbad query status changes
	//void onSimbadStatusChanged();
	//! Called when the user changed the input text
	void onTextChanged(const QString& text);
	void gotoObject();

private:
//	SimbadSearcher* simbadSearcher;
//	SimbadLookupReply* simbadReply;
//	QMap<QString, Vec3d> simbadResults;
	StelObjectMgr* objectMgr;

	QString substituteGreek(const QString& keyString);
	QString getGreekLetterByName(const QString& potentialGreekLetterName);
	QHash<QString, QString> greekLetters;
};

#endif // _SEARCHDIALOG_HPP_
