/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "PlanetsDialog.hpp"

#include "StelModuleMgr.hpp"
#include "StelApp.hpp"
#include "SolarSystem.hpp"

#include "MobileGui.hpp"

PlanetsDialog::PlanetsDialog(QWidget* parent) : QWidget(parent)
{
	setWindowFlags(windowFlags() | Qt::Window);
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

	setupUi(this);

	SolarSystem* ssmgr = GETSTELMODULE(SolarSystem);

	showPlanetCheckBox->setChecked(ssmgr->getFlagPlanets());
	connect(showPlanetCheckBox, SIGNAL(toggled(bool)), ssmgr, SLOT(setFlagPlanets(bool)));

	planetMarkerCheckBox->setChecked(ssmgr->getFlagHints());
	connect(planetMarkerCheckBox, SIGNAL(toggled(bool)), ssmgr, SLOT(setFlagHints(bool)));

	planetOrbitCheckBox->setChecked(ssmgr->getFlagOrbits());
	connect(planetOrbitCheckBox, SIGNAL(toggled(bool)), ssmgr, SLOT(setFlagOrbits(bool)));

	planetLightSpeedCheckBox->setChecked(ssmgr->getFlagLightTravelTime());
	connect(planetLightSpeedCheckBox, SIGNAL(toggled(bool)), ssmgr, SLOT(setFlagLightTravelTime(bool)));
}
