/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "ListPicker.hpp"

#include <QDebug>
#include <QSortFilterProxyModel>

ListPicker::ListPicker(const QString& title, QStringListModel* model, QWidget *parent) : QDialog(parent)
{
	setupUi(this);
	this->setWindowTitle(title);
	QSortFilterProxyModel *proxyModel = new QSortFilterProxyModel(this);
	proxyModel->setSourceModel(model);
	listView->setModel(proxyModel);
	lineEdit->setFocus();
	connect(lineEdit, SIGNAL(textChanged(const QString&)), proxyModel, SLOT(setFilterWildcard(const QString&)));
	connect(listView, SIGNAL(activated(QModelIndex)), this, SLOT(onActivated(QModelIndex)));
}

void ListPicker::onActivated(const QModelIndex& index)
{
	value = index.data().toString();
	selected(value);
	hide();
}

void ListPicker::select(const QString& value) {
	QAbstractItemModel* model = listView->model();
	QModelIndexList matches = model->match(model->index(0, 0), 0, value, 1,
										   Qt::MatchFlags(Qt::MatchExactly));
	if (!matches.empty()) {
		listView->selectionModel()->select(matches[0], QItemSelectionModel::ClearAndSelect);
		listView->selectionModel()->setCurrentIndex(matches[0], QItemSelectionModel::ClearAndSelect);
		listView->scrollTo(matches[0]);
	}
}
