/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "LandscapeDialog.hpp"

#include "StelModuleMgr.hpp"
#include "StelApp.hpp"
#include "LandscapeMgr.hpp"
#include "StelGuiBase.hpp"

LandscapeDialog::LandscapeDialog(QWidget *parent) : QDialog(parent)
{
	setupUi(this);

	// Connect all the signals
	landscapesListWidget->blockSignals(true);
	landscapesListWidget->clear();
	LandscapeMgr* lmgr = GETSTELMODULE(LandscapeMgr);
	landscapesListWidget->addItems(lmgr->getAllLandscapeNames());
	landscapesListWidget->setCurrentItem(landscapesListWidget->findItems(lmgr->getCurrentLandscapeName(), Qt::MatchExactly).at(0));
	landscapesListWidget->blockSignals(false);
	landscapeTextBrowser->setHtml(lmgr->getCurrentLandscapeHtmlDescription());

	connect(landscapesListWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(landscapeChanged(QListWidgetItem*)));

	useAsDefaultLandscapeCheckBox->setChecked(lmgr->getCurrentLandscapeID()==lmgr->getDefaultLandscapeID());
	useAsDefaultLandscapeCheckBox->setEnabled(lmgr->getCurrentLandscapeID()!=lmgr->getDefaultLandscapeID());
	connect(useAsDefaultLandscapeCheckBox, SIGNAL(clicked()), this, SLOT(setCurrentLandscapeAsDefault()));
}

void LandscapeDialog::landscapeChanged(QListWidgetItem* item)
{
	LandscapeMgr* lmgr = GETSTELMODULE(LandscapeMgr);
	lmgr->setCurrentLandscapeName(item->text());
	landscapeTextBrowser->setHtml(lmgr->getCurrentLandscapeHtmlDescription());
	useAsDefaultLandscapeCheckBox->setChecked(lmgr->getDefaultLandscapeID()==lmgr->getCurrentLandscapeID());
	useAsDefaultLandscapeCheckBox->setEnabled(lmgr->getDefaultLandscapeID()!=lmgr->getCurrentLandscapeID());
}

void LandscapeDialog::setCurrentLandscapeAsDefault(void)
{
	LandscapeMgr* lmgr = GETSTELMODULE(LandscapeMgr);
	Q_ASSERT(lmgr);
	lmgr->setDefaultLandscapeID(lmgr->getCurrentLandscapeID());
	useAsDefaultLandscapeCheckBox->setChecked(true);
	useAsDefaultLandscapeCheckBox->setEnabled(false);
}
