/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "ConstellationsMarkingDialog.hpp"

#include <QLayout>
#include <QCheckBox>
#include <QDoubleSpinBox>
#include <QAction>

#include "ConstellationMgr.hpp"
#include "StelModuleMgr.hpp"
#include "StelApp.hpp"
#include "StelGuiBase.hpp"
#include "StelTranslator.hpp"

ConstellationsMarkingDialog::ConstellationsMarkingDialog(QWidget* parent) : QWidget(parent)
{
	setWindowFlags(windowFlags() | Qt::Window);
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

	setWindowTitle("constellations");
	QVBoxLayout* vLayout = new QVBoxLayout(this);
	QGridLayout* layout = new QGridLayout;
	vLayout->addLayout(layout);

	// QVBoxLayout* layout = new QVBoxLayout(central);
	QCheckBox* showConstellationLinesCheckBox = new QCheckBox(q_("Show lines"));
	layout->addWidget(showConstellationLinesCheckBox, 0, 0);
	QCheckBox* showConstellationLabelsCheckBox = new QCheckBox(q_("Show labels"));
	layout->addWidget(showConstellationLabelsCheckBox, 1, 0);
	QCheckBox* showConstellationBoundariesCheckBox = new QCheckBox(q_("Show boundaries"));
	layout->addWidget(showConstellationBoundariesCheckBox, 0, 1);
	QCheckBox* showConstellationArtCheckBox = new QCheckBox(q_("Show art"));
	layout->addWidget(showConstellationArtCheckBox, 1, 1);

	vLayout->addStretch();

	// Connect all the signals
	ConstellationMgr* cmgr = GETSTELMODULE(ConstellationMgr);
	StelGuiBase* gui = StelApp::getInstance().getGui();
	QAction* a;

	showConstellationLinesCheckBox->setChecked(cmgr->getFlagLines());
	a = gui->getGuiActions("actionShow_Constellation_Lines");
	connect(a, SIGNAL(toggled(bool)), showConstellationLinesCheckBox, SLOT(setChecked(bool)));
	connect(showConstellationLinesCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showConstellationLabelsCheckBox->setChecked(cmgr->getFlagLabels());
	a = gui->getGuiActions("actionShow_Constellation_Labels");
	connect(a, SIGNAL(toggled(bool)), showConstellationLabelsCheckBox, SLOT(setChecked(bool)));
	connect(showConstellationLabelsCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showConstellationBoundariesCheckBox->setChecked(cmgr->getFlagBoundaries());
	a = gui->getGuiActions("actionShow_Constellation_Boundaries");
	connect(a, SIGNAL(toggled(bool)), showConstellationBoundariesCheckBox, SLOT(setChecked(bool)));
	connect(showConstellationBoundariesCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));

	showConstellationArtCheckBox->setChecked(cmgr->getFlagArt());
	a = gui->getGuiActions("actionShow_Constellation_Art");
	connect(a, SIGNAL(toggled(bool)), showConstellationArtCheckBox, SLOT(setChecked(bool)));
	connect(showConstellationArtCheckBox, SIGNAL(toggled(bool)), a, SLOT(setChecked(bool)));
}
