/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef TIMEWIDGET_HPP
#define TIMEWIDGET_HPP

#include <QWidget>

class TimeWidget : public QWidget
{
	Q_OBJECT
public:
	TimeWidget();

signals:
	void rateChanged(double rate);

public slots:
	void setRate(double rate);

private slots:
	void timeNow();
	void computeRate();

private:
	class QPushButton* backButton;
	class QSlider* slider;
	class QLabel* label;
};

#endif // TIMEWIDGET_HPP
