/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "QuickBar.hpp"
#include "ImageButton.hpp"
#include "StelApp.hpp"
#include "StelGuiBase.hpp"
#include "ButtonGroup.hpp"
#include "HelpMessage.hpp"

#include <QGraphicsAnchorLayout>
#include <QGraphicsLinearLayout>
#include <QGraphicsSceneMouseEvent>
#include <QDebug>

QuickBar::QuickBar(QGraphicsItem* parent, HelpMessage* msg): QGraphicsWidget(parent)
{
	QGraphicsAnchorLayout* layout = new QGraphicsAnchorLayout(this);
	setLayout(layout);
	layout->setSpacing(13);
	layout->setContentsMargins(3, 3, 3, 3);
	setContentsMargins(0, 0, 0, 0);
	StelGuiBase* gui = StelApp::getInstance().getGui();

	ButtonGroup* constellationGroup = new ButtonGroup(this);
	constellationGroup->add(new ImageButton(":/mobile/constellationLines.png", gui->getGuiActions("actionShow_Constellation_Lines"), NULL, "", msg));
	constellationGroup->add(new ImageButton(":/mobile/constellationLabels.png", gui->getGuiActions("actionShow_Constellation_Labels"), NULL, "", msg));
	constellationGroup->add(new ImageButton(":/mobile/starlore.png", gui->getGuiActions("actionShow_Constellation_Art"), NULL, "", msg));

	ButtonGroup* gridGroup = new ButtonGroup(this);
	gridGroup->add(new ImageButton(":/mobile/equatorialGrid.png", gui->getGuiActions("actionShow_Equatorial_Grid"), NULL, "", msg));
	gridGroup->add(new ImageButton(":/mobile/azimuthalGrid.png", gui->getGuiActions("actionShow_Azimuthal_Grid"), NULL, "", msg));
	layout->addCornerAnchors(gridGroup, Qt::TopLeftCorner, constellationGroup, Qt::TopRightCorner);

	ButtonGroup* searchGroup = new ButtonGroup(this);
	searchGroup->add(new ImageButton(":/mobile/search.png", gui->getGuiActions("actionShow_SearchDialog"), NULL, "", msg));
	layout->addCornerAnchors(searchGroup, Qt::TopLeftCorner, gridGroup, Qt::TopRightCorner);

	ButtonGroup* landscapeGroup = new ButtonGroup(this);
	landscapeGroup->add(new ImageButton(":/mobile/landscape.png", gui->getGuiActions("actionShow_Landscape"), NULL, "", msg));
	landscapeGroup->add(new ImageButton(":/mobile/location.png", gui->getGuiActions("actionShow_Cardinal_Points"), NULL, "", msg));
	layout->addCornerAnchors(landscapeGroup, Qt::TopLeftCorner, constellationGroup, Qt::BottomLeftCorner);

	ButtonGroup* nebulaGroup = new ButtonGroup(this);
	nebulaGroup->add(new ImageButton(":/mobile/nebulas.png", gui->getGuiActions("actionShow_Nebulas"), NULL, "", msg));
	nebulaGroup->add(new ImageButton(":/mobile/planets.png", gui->getGuiActions("actionShow_Planets_Labels"), NULL, "", msg));
	layout->addCornerAnchors(nebulaGroup, Qt::TopLeftCorner, landscapeGroup, Qt::TopRightCorner);

	ButtonGroup* modeGroup = new ButtonGroup(this);
	modeGroup->add(new ImageButton(":/mobile/sensors.png", gui->getGuiActions("actionAccelerometerControl"), NULL, "", msg));
	layout->addCornerAnchors(modeGroup, Qt::TopLeftCorner, nebulaGroup, Qt::TopRightCorner);

	ButtonGroup* fullscreenGroup = new ButtonGroup(this);
	fullscreenGroup->add(new ImageButton(":/mobile/fullScreen.png", gui->getGuiActions("actionToggle_FullScreen"), NULL, "", msg));
	layout->addCornerAnchors(fullscreenGroup, Qt::TopLeftCorner, modeGroup, Qt::TopRightCorner);
	layout->addCornerAnchors(fullscreenGroup, Qt::BottomRightCorner, layout, Qt::BottomRightCorner);

	setCacheMode(QGraphicsItem::ItemCoordinateCache);
}

void QuickBar::mousePressEvent(QGraphicsSceneMouseEvent* event)
{
	event->accept();
}
