/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _MOBILEGUI_HPP_
#define _MOBILEGUI_HPP_

#include "StelGuiBase.hpp"
#include <QGraphicsWidget>

#ifdef Q_WS_MAEMO_5
 #include <QDBusInterface>
#endif

class QActionGroup;
class QMenuBar;
class QMainWindow;
class MobileLocationMgr;

//! @class MobileGui
class MobileGui : public QObject, public StelGuiBase
{
	Q_OBJECT
public:
	MobileGui() : baseItem(NULL) {;}
	~MobileGui() {;}
	virtual void init(QGraphicsWidget* topLevelGraphicsWidget, class StelAppGraphicsWidget* stelAppGraphicsWidget);
	virtual void setStelStyle(const QString&) {;}
	virtual void setInfoTextFilters(const StelObject::InfoStringGroup& aflags) {dummyInfoTextFilter=aflags;}
	virtual const StelObject::InfoStringGroup& getInfoTextFilters() const {return dummyInfoTextFilter;}
	virtual class QProgressBar* addProgressBar();
	virtual void forceRefreshGui() {;}
	virtual void setVisible(bool b) {visible=b;}
	virtual bool getVisible() const {return visible;}
	virtual bool isCurrentlyUsed() const {return false;}
	//void grabZoomKeys(bool b);

	class GuiBaseItem* getGuiBaseItem() {return baseItem;}

protected:
	void createActions();

private slots:
	void zoomInAuto();
	void zoomOutAuto();
	void cb_func(const QDBusMessage& rep);

private:
	class GuiBaseItem* baseItem;
	StelObject::InfoStringGroup dummyInfoTextFilter;
	bool visible;
};

//! An example GUI plugin with an empty GUI.
class MobileGuiPluginInterface : public QObject, public StelGuiPluginInterface
{
	Q_OBJECT
	Q_INTERFACES(StelGuiPluginInterface)
public:
	virtual class StelGuiBase* getStelGuiBase() const;
};


class DialogCreator : public QObject
{
	Q_OBJECT
public:
	DialogCreator(const QMetaObject* metaClass) : metaClass(metaClass) {}
public slots:
	void show();
private:
	const QMetaObject* metaClass;
};


// TODO: move this into a separated file
class GuiBaseItem : public QGraphicsWidget
{
	Q_OBJECT
public:
	GuiBaseItem(MobileGui* mobileGui, StelAppGraphicsWidget* parent);
	MobileLocationMgr* getLocationMgr() const {return locMgr;}
	
public slots:
	void setAccelerometersControl(bool b);
	bool getAccelerometersControl() const {return accelerometerControl;}

signals:
	void clicked();

protected:
	virtual void paint(class QPainter*, const QStyleOptionGraphicsItem*, QWidget*);

	QMenuBar* createMenuBar(QMainWindow* mainWindow);
	QGraphicsItem* createStatusBar();
	void addDialogInMenuBar(const QString& name, const QMetaObject* metaClass);

	void update();
	virtual bool eventFilter(QObject *obj, QEvent *ev);
	virtual bool sceneEventFilter(QGraphicsItem* watched, QEvent* event);
	virtual void mousePressEvent(QGraphicsSceneMouseEvent* event);
	virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent* event);

private slots:
	void setDragTimeMode(bool);
	void timeBarStateWasEntered();
	void timeBarStateWasExited();
	
private:
	MobileGui* mobileGui;

	class GraphicsTextLabel* fps;
	class ImageButton* quickButton;
	class ImageButton* timeBarButton;
	class QuickBar* quickBar;
	class TimeBar* timeBar;
	class InfoPanel* infoPanel;
	class StatusBar* statusBar;
	class HelpMessage* helpMessage;
	bool accelerometerControl;

	MobileLocationMgr* locMgr;
	
	bool savedGridFlag;
	bool lastWasDragging;

	int firstUpdate;
	bool fastForwardToNight;
	float startFastForwardTime;
	QList<float> previousSinSun;
};

#endif // _MOBILEGUI_HPP_
