/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "HelpMessage.hpp"
#include "GraphicsTextLabel.hpp"
#include <QTimer>
#include <QDebug>
#include <QAction>
#include <QGraphicsAnchorLayout>
#include <QStateMachine>
#include <QPropertyAnimation>
#include <QSignalTransition>

#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif

HelpMessage::HelpMessage(QGraphicsItem* parent): GraphicsTextLabel("     ", parent, 35), sustainDuration(1200)
{
	timer = new QTimer(this);
	timer->setSingleShot(true);
	QObject::connect(timer, SIGNAL(timeout()), this, SLOT(hideHelpMessage()));

	QStateMachine* messageStateMachine = new QStateMachine(this);
	QState* stateOn = new QState();
	stateOn->assignProperty(this, "opacity", 1.0);
	QState* stateOff = new QState();
	stateOff->assignProperty(this, "opacity", 0);

	QPropertyAnimation* an1 = new QPropertyAnimation(this, "opacity");
	an1->setDuration(200);
	QPropertyAnimation* an2 = new QPropertyAnimation(this, "opacity");
	an2->setDuration(1500);
	QSignalTransition* trHelpMessage = stateOff->addTransition(this, SIGNAL(displayHelpMessageSig()), stateOn);
	QSignalTransition* trHelpMessage2 = stateOn->addTransition(this, SIGNAL(hideHelpMessageSig()), stateOff);
	trHelpMessage->addAnimation(an1);
	trHelpMessage2->addAnimation(an2);
	QObject::connect(stateOn, SIGNAL(entered()), this, SLOT(startTimerForHelpMessage()));

	messageStateMachine->addState(stateOn);
	messageStateMachine->addState(stateOff);
	messageStateMachine->setInitialState(stateOff);
	messageStateMachine->start();
}

void HelpMessage::startTimerForHelpMessage()
{
	timer->start(sustainDuration);
}

void HelpMessage::hideHelpMessage()
{
	timer->stop();
	emit(hideHelpMessageSig());
}

void HelpMessage::displayMessage(const QString& msg, int duration)
{
	sustainDuration = duration;
	setText(msg);
	if (timer->isActive())
	{
		hideHelpMessage();
	}
	emit (displayHelpMessageSig());
}
