/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef GRAPHICSTEXTLABEL_HPP
#define GRAPHICSTEXTLABEL_HPP

#include <QGraphicsWidget>

class GraphicsTextLabel : public QGraphicsWidget
{
	Q_OBJECT

public:
	GraphicsTextLabel(const QString& text, QGraphicsItem* parent=NULL, int fontSize=18);
	void setText(const QString&);
	QString text() const;
	void setOffset(int, int);
	void setBold(bool b);
	
signals:
	void toggled(bool checked);
	void triggered();

public slots:
	void setChecked(bool b);

//protected:
//	QSizeF sizeHint(Qt::SizeHint which, const QSizeF& constraint = QSizeF()) const;

private:
	QGraphicsSimpleTextItem* textItem;
	bool checkable;
	bool checked;
};

#endif // GRAPHICSTEXTLABEL_HPP
