/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "GraphicsTextLabel.hpp"
#include <QAction>
#include <QGraphicsDropShadowEffect>

GraphicsTextLabel::GraphicsTextLabel(const QString& text, QGraphicsItem* parent, int fontSize) :
		QGraphicsWidget(parent), checkable(false), checked(false)
{
	textItem = new QGraphicsSimpleTextItem(this);
	textItem->setText(text);
	textItem->setPos(5,5);
	QColor color = QColor::fromRgbF(1,1,1,1);
	textItem->setBrush(color);
	QFont font;
	font.setPixelSize(fontSize);
	textItem->setFont(font);

	QGraphicsDropShadowEffect* shadow = new QGraphicsDropShadowEffect(this);
	shadow->setOffset(1.);
	shadow->setColor(QColor(0, 0, 0, 255));
	setGraphicsEffect(shadow);
	setCacheMode(QGraphicsItem::ItemCoordinateCache);
}

void GraphicsTextLabel::setBold(bool b)
{
	QFont f = textItem->font();
	f.setBold(b);
	textItem->setFont(f);
}

void GraphicsTextLabel::setOffset(int x, int y)
{
	textItem->setPos(x, y);
}

void GraphicsTextLabel::setText(const QString& s)
{
	textItem->setText(s);
	setPreferredSize(textItem->boundingRect().size()+QSize(10,5));
}

QString GraphicsTextLabel::text() const
{
	return textItem->text();
}

//QSizeF StatusButton::sizeHint(Qt::SizeHint, const QSizeF&) const
//{
//	QRectF rec = textItem->boundingRect();
//	return QSizeF(rec.width()+10, rec.height()+10);
//}

void GraphicsTextLabel::setChecked(bool b)
{
	if (checkable && b==checked)
		return;

	checked=b;
	setOpacity(b?1:0.8);
	if (checkable)
		emit toggled(checked);
}
