#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Librarys
###########################################################################################
import gtk, hildon, os, dbus, gconf, commands, pango, gobject, socket, time
from hildondesktop import StatusMenuItem
from threading import Thread

#Classes
###########################################################################################
class WlanDriverStatusPlugin(StatusMenuItem):
	def __init__(self):
		StatusMenuItem.__init__(self)
		self.disableButtons = True
		self.bus = dbus.bus.BusConnection('unix:path=/var/run/dbus/system_bus_socket')
		self.Notifications = Notifications(self)
		self.DriverLoader = DriverLoader(self)
		self.Config = Config()
		self.driverButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		self.driverButton.set_label('Bleeding Edge')
		self.driverButton.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/48x48/hildon/wifi-bleeding.png'))
		self.driverButton.connect('clicked', self.changeDrivers, 'switch')
		self.disableButton = hildon.GtkToggleButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		self.disableButton.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/48x48/hildon/location_applet_on.png'))
		self.disableButton.connect('clicked', self.changeDrivers, 'disable')
		self.updateButtons(self.getDriverStatus())
		hbox = gtk.HBox(False, 0)
		hbox.pack_start(self.driverButton, True, True, 0)
		hbox.pack_start(self.disableButton, False, False, 0)
		self.add(hbox)
		self.disableButtons = False
		self.show_all()

	def changeDrivers(self, button, action):
		if not self.disableButtons:
			failed = False
			#self.Notifications.notify(str(button.get_active())+'|'+action)
			#Current drivers
			realDrivers = self.getDriverStatus()
			#Wanted drivers
			if action == 'disable' and not button.get_active():
				wantedDrivers = 0
			elif action == 'disable' and button.get_active():
				if self.driverButton.get_active():
					wantedDrivers = 2
				else:
					wantedDrivers = 1
			elif action == 'switch' and not button.get_active():
				wantedDrivers = 1
			elif action == 'switch' and button.get_active():
				wantedDrivers = 2
			#Do we really already have the wanted drivers?
			if realDrivers == wantedDrivers:
				if realDrivers == 0: self.Notifications.notify('Wlan is already in disabled')
				elif realDrivers == 1: self.Notifications.notify('Stock drivers are already in use')
				elif realDrivers == 2: self.Notifications.notify('Bleeding Edge drivers are already in use')
			#Change the drivers
			else:
				folder = ''
				if wantedDrivers == 2:
					folder = self.Config.getFolder()
					if self.Config.checkFolder(folder) == False:
						failed = True
				if not failed:
					wantedDrivers = self.DriverLoader.load(folder, wantedDrivers)
			if failed:
				self.updateButtons(self.getDriverStatus())
				self.Notifications.notify('Couldn\'t find Bleeding Edge drivers')
				gobject.idle_add(self.openSetupDialog)
			else:
				self.updateButtons(wantedDrivers)

	def openSetupDialog(self):
		SetupDialog(self)

	def updateButtons(self, driver):
		#self.Notifications.notify(str(driver))
		self.disableButtons = True
		if driver == 0:
			self.disableButton.set_active(False)
			self.set_status_area_icon(gtk.gdk.pixbuf_new_from_file('/usr/share/icons/hicolor/18x18/hildon/wifi-off.png'))
			#self.driverButton.setDisabled(True)
		elif driver == 1:
			self.disableButton.set_active(True)
			self.driverButton.set_active(False)
			self.set_status_area_icon()
			#self.driverButton.setDisabled(False)
		elif driver == 2:
			self.disableButton.set_active(True)
			self.driverButton.set_active(True)
			self.set_status_area_icon()
			#self.driverButton.setDisabled(False)
		self.disableButtons = False

	def getDriverStatus(self):
		f = open('/proc/modules', 'r')
		for line in f.readlines():
			if line.startswith('wl1251'):
				f.close()
				return 2
			if line.startswith('wl12xx'):
				f.close()
				return 1
		f.close()
		return 0

class DriverLoader(Thread):
	def __init__(self, Parent):
		Thread.__init__(self)
		self.Parent = Parent
	def run(self):
		pass
	def load(self, folder, driver):
		#Notify about loading starting
		if driver == 0:	self.Parent.Notifications.notify('Disabling WLAN..')
		elif driver == 1: self.Parent.Notifications.notify('Loading Stock drivers..')
		elif driver == 2: self.Parent.Notifications.notify('Loading Bleeding Edge drivers..')
		#Load
		if driver == 2:	output = commands.getoutput('cd '+folder+'; sudo /sbin/load-bleeding-edge-drivers.sh')
		elif driver == 1: output = commands.getoutput('sudo /sbin/load-stock-drivers.sh')
		else: output = commands.getoutput('sudo /sbin/unload-drivers.sh')
		#Check driver status
		realDrivers = self.Parent.getDriverStatus()
		if realDrivers != driver:
			if driver == 0:
				output2 = 'Drivers were not unloaded'
			else:
				output2 = 'Drivers were not loaded'
			if len(output) == 0:
				output = output2
			else:
				output += '\n'+output2
			
		#Notify about loading stopping
		if len(output)>0:
			if driver == 0:	self.Parent.Notifications.notify(output, 'Error while disabling WLAN')
			elif driver == 1: self.Parent.Notifications.notify(output, 'Error while loading Stock drivers')
			elif driver == 2: self.Parent.Notifications.notify(output, 'Error while loading Bleeding Edge drivers')
		else:
			if driver == 0:	self.Parent.Notifications.notify('Disabled WLAN')
			elif driver == 1: self.Parent.Notifications.notify('Loaded Stock drivers')
			elif driver == 2: self.Parent.Notifications.notify('Loaded Bleeding Edge drivers')
			if driver > 0:
				proxy = self.Parent.bus.get_object('com.nokia.icd_ui', '/com/nokia/icd_ui', 'com.nokia.icd_ui')
				proxy.show_conn_dlg(False)
		return realDrivers

class Notifications:
	def __init__(self, Parent):
		self.bus = Parent.bus

	def notify(self, message, title=False):
		if hasattr(self, 'object') == False or hasattr(self, 'interface') == False:
			try:
				self.object = self.bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
				self.interface = dbus.Interface(self.object,dbus_interface='org.freedesktop.Notifications')
			except:
				pass
		if hasattr(self, 'object') and hasattr(self, 'interface'):
			try:
				if title:
					dialog = gtk.Dialog(title)
					dialog.set_geometry_hints(min_height=800)
					panArea = hildon.PannableArea()
					panArea.set_property('mov-mode', hildon.MOVEMENT_MODE_VERT)
					textview = hildon.TextView()
					textbuffer = gtk.TextBuffer()
					textbuffer.set_text(message)
					textview.set_buffer(textbuffer)
					textview.set_editable(False)
					textview.set_wrap_mode(gtk.WRAP_WORD)
					#textview.set_cursor_visible(False)
					panArea.add_with_viewport(textview)
					dialog.vbox.add(panArea)
					dialog.show_all()
				else:
					self.interface.SystemNoteInfoprint(message)
			except:
				pass

class Config:
	def __init__(self):
		self.Client = gconf.client_get_default()
		self.filesNeeded = ['cfg80211.ko', 'rfkill_backport.ko', 'wl1251.ko', 'compat.ko', 'mac80211.ko', 'wl1251_spi.ko']

	def checkFolder(self, folder):
		try:
			missing = False
			files = []
			for file in os.listdir(folder):
				files.append(file)
			for file in self.filesNeeded:
				if file not in files:
					return False
			return True
		except:
			return False

	def setFolder(self, folder):
		return self.Client.set_string('/apps/wlan_driver_selector/driver_folder', folder)

	def getFolder(self):
		try:
			return self.Client.get_value('/apps/wlan_driver_selector/driver_folder')
		except:
			return ''
	
class SetupDialog(gtk.Dialog, Thread):
	def __init__(self, Parent):
		Thread.__init__(self)
		gtk.gdk.threads_init()
		super(SetupDialog, self).__init__()
		self.driverLocation = 'http://files.laasonen.net/'
		self.driverName = 'wl1251-drivers.tar.gz'
		self.driverFolder = 'wl1251-drivers'
		self.Parent = Parent
		self.set_title('Wlan Driver Selector')
		selectButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		selectButton.set_title('Select location of Bleeding Edge drivers')
		selectButton.connect('clicked', self.selectFolder)
		helpButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		helpButton.set_title('Help')
		helpButton.connect('clicked', self.helpDialog)
		downloadButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		downloadButton.set_title('Download Bleeding Edge drivers')
		downloadButton.connect('clicked', self.download)
		websiteButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		websiteButton.set_title('Open Bleeding Edge drivers website')
		websiteButton.connect('clicked', self.openWebbrowser, 'http://david.gnedt.eu/blog/wl1251/')
		self.vbox.pack_start(selectButton)
		self.vbox.pack_start(downloadButton)
		self.vbox.pack_start(websiteButton)
		self.vbox.pack_start(helpButton)
		self.show_all()
		gtk.main()

	def selectFolder(self, ignore):
		chooser = hildon.FileChooserDialog(self, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
		chooser.set_default_response(gtk.RESPONSE_OK)
		chooser.run()
		folder = chooser.get_filename()
		chooser.destroy()
		if type(folder).__name__ == 'str':
			if self.Parent.Config.checkFolder(folder):
				self.Parent.Config.setFolder(folder)
				self.Parent.Notifications.notify('Folder selected succesfully')
				self.destroy()
				self.Parent.click(None)
			else:
				self.Parent.Notifications.notify('Couldn\'t find all needed files from:\n'+folder)
		else:
			self.Parent.Notifications.notify('Please select the folder which contains the Bleeding Edge drivers')

	def download(self, ignore):
		#Connect to internet if needed
		try:
			s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
			s.connect(('files.laasonen.net',80))
			connection = True
		except:
			connection = False
			proxy = self.Parent.bus.get_object('com.nokia.icd_ui', '/com/nokia/icd_ui', 'com.nokia.icd_ui')
			proxy.show_conn_dlg(False)
			for i in range(10):
				try:
					s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
					s.connect(('files.laasonen.net',80))
					connection = True
					break
				except:
					pass
				time.sleep(1)
		if connection:
			#Select folder
			chooser = hildon.FileChooserDialog(self, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
			chooser.set_default_response(gtk.RESPONSE_OK)
			chooser.run()
			folder = chooser.get_filename()
			chooser.destroy()
			extract = False
			if type(folder).__name__ == 'str':
				os.chdir(folder)
				#Import librarys needed by downloader
				import sys
				sys.path.append('/opt/EasyDialogs')
				from EasyDialogs import ProgressBar
				from urllib import urlretrieve
				#Download
				try:
					bar = ProgressBar(title='Downloading Bleeding Edge Drivers', label='Downloading Bleeding Edge Drivers')
					def report(block_count, block_size, total_size):
						if block_count == 0:
							bar.set(0, total_size)
						bar.inc(block_size)
					if urlretrieve(self.driverLocation+''+self.driverName, self.driverName, reporthook=report):
						self.Parent.Notifications.notify('Drivers downloaded succesfully')
						extract = True
					else:
						self.Parent.Notifications.notify('Download failed')
					bar.__del__()
				except:
					self.Parent.Notifications.notify('Download canceled')
			else:
				self.Parent.Notifications.notify('Please select a folder for Bleeding Edge drivers')
		else:
			self.Parent.Notifications.notify('Couldn\'t create connection')
		if extract:
			try:
				import tarfile
				tar = tarfile.open(self.driverName, 'r:gz')
				tar.extractall()
				self.Parent.Config.setFolder(folder+'/'+self.driverFolder)
				self.Parent.Notifications.notify('Success, drivers are now installed')
			except:
				self.Parent.Notifications.notify('Extraction failed')

	def helpDialog(self, ignore):
		dialog = gtk.Dialog('Help')
		dialog.set_geometry_hints(min_height=800)
		panArea = hildon.PannableArea()
		panArea.set_property('mov-mode', hildon.MOVEMENT_MODE_VERT)
		text = '[B]Description\nThis applet lets you select your wlan drivers and disable wlan easily.\n\n[B]Help:\nYou need to download Bleeding Edge drivers to MyDocs or your memory card. You need atleast 46-wl1 version of kernel-power to use them.'
		textview = hildon.TextView()
		textbuffer = gtk.TextBuffer()
		textbuffer.set_text(text.replace('[B]',''))
		#Add tags
		bold = textbuffer.create_tag(weight=pango.WEIGHT_BOLD)
		for i, line in enumerate(text.split('\n')):
			if line.startswith('[B]'):
				start = textbuffer.get_iter_at_line_offset(i, 0)
				stop = textbuffer.get_iter_at_line_offset(i, len(line.replace('[B]','')))
				textbuffer.apply_tag(bold, start, stop)
		textview.set_buffer(textbuffer)
		textview.set_editable(False)
		textview.set_wrap_mode(gtk.WRAP_WORD)
		textview.set_cursor_visible(False)
		panArea.add_with_viewport(textview)
		dialog.vbox.add(panArea)
		dialog.show_all()

	def openWebbrowser(self, ignore, url):
		proxy = self.Parent.bus.get_object('com.nokia.osso_browser', '/com/nokia/osso_browser/request', 'com.nokia.osso_browser')
		proxy.load_url(url, dbus_interface='com.nokia.osso_browser')
		self.destroy()

#Run
###########################################################################################
hd_plugin_type = WlanDriverStatusPlugin
