#!/bin/sh

# Discconect if needed
CONNECTION="`ifconfig wlan0 | grep -c RUNNING`" 2> /dev/null
if [ $CONNECTION -gt "0" ]; then
	run-standalone.sh dbus-send --system --dest=com.nokia.icd /com/nokia/icd_ui com.nokia.icd_ui.disconnect boolean:true
fi

# Try to retrieve mac-address
MACADDR="`ifconfig wlan0 | sed -n 's/.*HWaddr \([0-9A-Fa-f:]\+\).*/\1/p'`" 2> /dev/null
if [ -z $MACADDR ] ; then
	MACADDR="`cat /tmp/mac-address`" 2> /dev/null
	if [ -z $MACADDR ]; then
		echo "Couldn't retrieve mac-address"
	fi
fi

# Reset IP
ifconfig wlan0 0.0.0.0 2> /dev/null

# Shut down wlan0 interface
ifconfig wlan0 down 2> /dev/null

# Unload wifi modules
rmmod wl1251_spi 2> /dev/null
rmmod wl1251 2> /dev/null
rmmod wl12xx 2> /dev/null
rmmod mac80211 2> /dev/null
rmmod cfg80211 2> /dev/null
rmmod rfkill_backport 2> /dev/null
rmmod compat_firmware_class 2> /dev/null
rmmod compat 2> /dev/null

# Load bleeding-edge wl1251
TMPFILE=`mktemp /tmp/temp.XXXXXX`
insmod compat.ko 2> $TMPFILE
insmod rfkill_backport.ko 2>> $TMPFILE
insmod cfg80211.ko 2>> $TMPFILE
insmod mac80211.ko 2>> $TMPFILE
insmod wl1251.ko 2>> $TMPFILE
insmod wl1251_spi.ko 2>> $TMPFILE
if [ -n "`cat $TMPFILE`" ] ; then
	echo "Error while loading kernel modules"
fi

# Recover and save mac-address
if [ -n $MACADDR ]; then
	ifconfig wlan0 down hw ether "$MACADDR"
	echo $MACADDR > /tmp/mac-address
else
	MACADDR="`ifconfig wlan0 | sed -n 's/.*HWaddr \([0-9A-Fa-f:]\+\).*/\1/p'`" 2> /dev/null
	if [ -n $MACADDR ]; then
		echo $MACADDR > /tmp/mac-address
	fi
fi

# Restart wlancond
STOP="`stop wlancond`" 2> /dev/null
START="`start wlancond`" 2> /dev/null
if [ "$?" -gt "0" ]; then
	echo "Error while restarting wlancond, propably respawning too fast"
fi

# Start wlan0 interface
ifconfig wlan0 up 2> /dev/null
if [ "$?" -gt "0" ]; then
	echo "Error while starting wlan0 interface"
fi
