#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Librarys
###########################################################################################
import gtk, hildon, os, dbus, gconf, commands, pango
from hildondesktop import StatusMenuItem

#Classes
###########################################################################################
class WlanDriverStatusPlugin(StatusMenuItem):
	def __init__(self):
		StatusMenuItem.__init__(self)
		self.bus = dbus.bus.BusConnection('unix:path=/var/run/dbus/system_bus_socket')
		self.Notifications = Notifications(self)
		self.Config = Config()
		self.status = self.getDriverStatus()
		self.button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		self.button.set_style(hildon.BUTTON_STYLE_PICKER)
		self.button.set_alignment(0,0,1,1)
		self.updateButton()
		self.button.connect('clicked', self.click)
		label = hildon.GtkToggleButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		self.add(self.button)
		self.show_all()

	def click(self, button):
		realStatus = self.getDriverStatus()
		if realStatus != self.status:
			if self.status:
				self.Notifications.notify("Stock drivers are already in use")
			else:
				self.Notifications.notify("Bleeding Edge drivers are already in use")
			self.status = realStatus
		else:
			folder = self.Config.getFolder()
			if self.Config.checkFolder(folder):
				if self.status:
					self.loadDrivers(folder, False)
				else:
					self.loadDrivers(folder, True)
			else:
				SetupDialog(self)
		self.updateButton()

	def loadDrivers(self, folder, driver):
		if driver:
			file = '/sbin/load-bleeding-edge-drivers.sh'
		else:
			file = '/sbin/unload-bleeding-edge-drivers.sh'
		output = commands.getoutput('cd '+folder+'; sudo '+file)
		if driver:
			if len(output)>0:
				self.Notifications.notify('Error while loading Bleeding Edge drivers:\n'+output)
			else:
				self.Notifications.notify('Loaded Bleeding Edge drivers')
		else:
			if len(output)>0:
				self.Notifications.notify('Error while loading Stock drivers:\n'+output)
			else:
				self.Notifications.notify('Loaded Stock drivers')
		self.status = driver

	def updateButton(self):
		if self.status:
			self.button.set_text('Wlan Driver Selector', 'Bleeding Edge drivers')
			self.button.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/48x48/hildon/wifi-bleeding.png'))
		else:
			self.button.set_text('Wlan Driver Selector', 'Stock drivers')
			self.button.set_image(gtk.image_new_from_file('/usr/share/icons/hicolor/48x48/hildon/wifi-stock.png'))

	def getDriverStatus(self):
		f = open('/proc/modules', "r")
		for line in f.readlines():
			if line.startswith('wl1251'):
				return True
		return False

class Notifications:
	def __init__(self, Parent):
		self.bus = Parent.bus

	def notify(self, message):
		if hasattr(self, 'object') == False or hasattr(self, 'interface') == False:
			try:
				self.object = self.bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
				self.interface = dbus.Interface(self.object,dbus_interface='org.freedesktop.Notifications')
			except:
				pass
		if hasattr(self, 'object') and hasattr(self, 'interface'):
			try:
				self.interface.SystemNoteInfoprint(message)
			except:
				pass

class Config:
	def __init__(self):
		self.Client = gconf.client_get_default()
		self.filesNeeded = ['cfg80211.ko', 'rfkill_backport.ko', 'wl1251.ko', 'compat.ko', 'mac80211.ko', 'wl1251_spi.ko']

	def checkFolder(self, folder):
		try:
			missing = False
			files = []
			for file in os.listdir(folder):
				files.append(file)
			for file in self.filesNeeded:
				if file not in files:
					return False
			return True
		except:
			return False

	def setFolder(self, folder):
		return self.Client.set_string('/apps/wlan_driver_selector/driver_folder', folder)

	def getFolder(self):
		try:
			return self.Client.get_value('/apps/wlan_driver_selector/driver_folder')
		except:
			return ''
	
class SetupDialog(gtk.Dialog):
	def __init__(self, Parent):
		super(SetupDialog, self).__init__()
		self.Parent = Parent
		self.set_title('Wlan Driver Selector')
		button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		button.set_title('Select location of Bleeding Edge drivers')
		button.connect('clicked', self.selectFolder)
		helpButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		helpButton.set_title('Help')
		helpButton.connect('clicked', self.helpDialog)
		downloadButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		downloadButton.set_title('Download Bleeding Edge drivers')
		downloadButton.connect('clicked', self.openWebbrowser, 'http://david.gnedt.eu/blog/wl1251/')
		self.vbox.pack_start(button)
		self.vbox.pack_start(helpButton)
		self.vbox.pack_start(downloadButton)
		self.show_all()
		gtk.main()

	def selectFolder(self, ignore):
		chooser = hildon.FileChooserDialog(self, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
		chooser.set_default_response(gtk.RESPONSE_OK)
		chooser.run()
		folder = chooser.get_filename()
		chooser.destroy()
		if type(folder).__name__ == 'str':
			if self.Parent.Config.checkFolder(folder):
				self.Parent.Config.setFolder(folder)
				self.Parent.Notifications.notify("Folder selected succesfully")
				self.destroy()
				self.Parent.click(None)
			else:
				self.Parent.Notifications.notify("Couldn't find all needed files from:\n"+folder)
		else:
			self.Parent.Notifications.notify("Please select the folder which contains the Bleeding Edge drivers")

	def helpDialog(self, ignore):
		dialog = gtk.Dialog('Help')
		dialog.set_geometry_hints(min_height=800)
		panArea = hildon.PannableArea()
		panArea.set_property('mov-mode', hildon.MOVEMENT_MODE_VERT)
		text = '[B]Description\nThis applet lets you select your wlan drivers easily.\n\n[B]Help:\nYou need to download Bleeding Edge drivers from the link provided on the previous window and save them to MyDocs or your memory card. You need atleast 46-wl1 version of kernel-power to use them.'
		textview = hildon.TextView()
		textbuffer = gtk.TextBuffer()
		textbuffer.set_text(text.replace('[B]',''))
		#Add tags
		bold = textbuffer.create_tag(weight=pango.WEIGHT_BOLD)
		for i, line in enumerate(text.split('\n')):
			if line.startswith('[B]'):
				start = textbuffer.get_iter_at_line_offset(i, 0)
				stop = textbuffer.get_iter_at_line_offset(i, len(line.replace('[B]','')))
				textbuffer.apply_tag(bold, start, stop)
		textview.set_buffer(textbuffer)
		textview.set_editable(False)
		textview.set_wrap_mode(gtk.WRAP_WORD)
		textview.set_cursor_visible(False)
		panArea.add_with_viewport(textview)
		dialog.vbox.add(panArea)
		dialog.show_all()

	def openWebbrowser(self, ignore, url):
		proxy = self.Parent.bus.get_object('com.nokia.osso_browser', '/com/nokia/osso_browser/request', 'com.nokia.osso_browser')
		proxy.load_url(url, dbus_interface='com.nokia.osso_browser')
		self.destroy()

#Run
###########################################################################################
hd_plugin_type = WlanDriverStatusPlugin
