class DebugDialog : Gtk.Dialog {

	Hildon.Entry entry;
	Gtk.Label log_label;
	TorControl.Connection? tor_control;

	/**
	 * Show the exit node configuration dialog
	 */
	public DebugDialog (TorControl.Connection? _tor_control = null) {
		var content = (Gtk.VBox) get_content_area ();
                content.set_size_request (-1, 5*70);

		set_title (_("Debug GETINFO"));

		tor_control = _tor_control;

		var pannable = new Hildon.PannableArea ();
		content.pack_start (pannable, true, true, 0);

		var vbox = new Gtk.VBox (false, 0);
		pannable.add_with_viewport (vbox);

		var hbox = new Gtk.HBox (false, 0);
		vbox.pack_start (hbox, false, false, 0);

		entry = new Hildon.Entry (Hildon.SizeType.FINGER_HEIGHT);
		hbox.pack_start (entry, true, true, 0);

		var button = new Hildon.Button.with_text (Hildon.SizeType.FINGER_HEIGHT,
		                                          Hildon.ButtonArrangement.VERTICAL,
		                                          "OK", "what?");
		button.set_alignment (0, 0.5f, 0, 0.5f);
		button.clicked.connect (on_button_clicked);
		hbox.pack_start (button, true, true, 0);

		log_label = new Gtk.Label ("");
		log_label.set_alignment (0, 0);
		vbox.pack_start (log_label, true, true, 0);

		content.show_all ();
	}

	void on_button_clicked () {
		if (tor_control != null) try {
			log_label.label = tor_control.get_info (entry.get_text ());
		} catch (Error e) {
			Hildon.Banner.show_information (this, null, "Error getting info: %s".printf (e.message));
		}
	}
}
