/* This file is part of libtorcontrol.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * libtorcontrol is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libtorcontrol is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libtorcontrol. If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <glib.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>

int tor_control_open_socket (int port, GError **error);

int tor_control_open_socket (int port, GError **error) {
	int status;
	char *service;
	struct addrinfo hints;
	struct addrinfo *result, *rp;
	int sockfd;
	int fd;

	memset (&hints, 0, sizeof hints);
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE;

	service = g_strdup_printf ("%d", port);

	status = getaddrinfo (NULL, service, &hints, &result);

	g_free (service);

	if (status != 0) {
		g_set_error (error,
		             /* domain: */ g_quark_from_string ("TORCTLERR"), /* code: */ 1,
		             "getaddrinfo error: %s", gai_strerror (status));
		return -1;
	}

	for (rp = result; rp != NULL; rp = rp->ai_next) {
		sockfd = socket (rp->ai_family, rp->ai_socktype,
		                 rp->ai_protocol);
		if (sockfd == -1)
			continue;

		status = connect (sockfd, rp->ai_addr, rp->ai_addrlen);
		if (status != -1)
			break;

		close (sockfd);
	}

	freeaddrinfo (result);

	if (rp == NULL) {
		g_set_error (error,
		             /* domain: */ g_quark_from_string ("TORCTLERR"), /* code: */ 2,
		             "socket/connect error: %s", strerror (errno));
		return -1;
	}

	return sockfd;
}

