/*
This file is part of ssh-status.

ssh-status is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ssh-status is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ssh-status.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <sys/wait.h>
#include <hildon/hildon.h>
#include "lib-ssh-status-menu-widget.h"

HD_DEFINE_PLUGIN_MODULE (SSHStatus, ssh_status, HD_TYPE_STATUS_MENU_ITEM);

static void 	button_toggle_act	(gpointer, gpointer);
static void 	button_killer_act	(gpointer, gpointer);
static gboolean	checker				(short);
static gboolean killer				(gpointer);

static void
ssh_status_class_finalize (SSHStatusClass *klass) {}

static void
ssh_status_class_init (SSHStatusClass *klass) {}

GtkWidget *button_toggle;
GtkWidget *button_killer;
GtkWidget *hbox;

static void ssh_status_init (SSHStatus *plugin){
	button_toggle = hildon_button_new (HILDON_SIZE_FINGER_HEIGHT,
			HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	button_killer = hildon_button_new (HILDON_SIZE_FINGER_HEIGHT,
			HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	g_idle_add((GSourceFunc) checker, (gpointer) 0);
	hildon_button_set_value (HILDON_BUTTON(button_killer), "killall sshd");

	g_signal_connect_after (G_OBJECT (button_toggle), "clicked",
			G_CALLBACK (button_toggle_act), plugin);
	g_signal_connect_after (G_OBJECT (button_killer), "clicked",
			G_CALLBACK (button_killer_act), plugin);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (hbox), button_toggle);
	gtk_container_add (GTK_CONTAINER (hbox), button_killer);
	gtk_container_add (GTK_CONTAINER (plugin), hbox);

	gtk_widget_show_all (button_toggle);
	gtk_widget_show_all (button_killer);
	gtk_widget_show_all (hbox);
	gtk_widget_show (GTK_WIDGET (plugin));
}

static gboolean checker(short toggle){
	static short status;
	if (toggle == 1)
		status = WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh toggle"));
	if (toggle == 0 || (status != 0 && status != 2) )
		status = WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh check"));

	if (status == 0)
		hildon_button_set_title (HILDON_BUTTON(button_toggle), "SSHD ON");
	else if (status == 2)
		hildon_button_set_title (HILDON_BUTTON(button_toggle), "SSHD OFF");
	else
		hildon_button_set_title (HILDON_BUTTON(button_toggle), "SSHD ?");

	return FALSE;
}

static gboolean killer(gpointer plugin){
	system("sudo /usr/sbin/ssh-status.sh kill");
	return FALSE;
}

static void button_toggle_act (gpointer instance, gpointer plugin){
	g_idle_add((GSourceFunc) checker, (gpointer) 1);
}

static void button_killer_act (gpointer instance, gpointer plugin){
	g_idle_add((GSourceFunc) killer, plugin);
}
