/*
This file is part of ssh-status.

ssh-status is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ssh-status is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ssh-status.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <sys/wait.h>
#include <hildon/hildon.h>

#include "lib-ssh-status-menu-widget.h"

#define SSH_STATUS_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, \
                            TYPE_SSH_STATUS, SSHStatusPrivate))

/*struct _SSHStatusPrivate
{
  
};*/

HD_DEFINE_PLUGIN_MODULE (SSHStatus, ssh_status, HD_TYPE_STATUS_MENU_ITEM);

static void ssh_status_button_toggle (gpointer, gpointer);
static void ssh_status_button_killer (gpointer, gpointer);

static void
ssh_status_class_finalize (SSHStatusClass *klass) {}

static void
ssh_status_class_init (SSHStatusClass *klass)
{
    //g_type_class_add_private (klass, sizeof (SSHStatusPrivate));
}

GtkWidget *button_toggle;
GtkWidget *button_killer;
GtkWidget *hbox;

static void ssh_status_init (SSHStatus *plugin)
{
    //plugin->priv = SSH_STATUS_GET_PRIVATE (plugin);

    button_toggle = hildon_button_new (HILDON_SIZE_FINGER_HEIGHT,
            HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    button_killer = hildon_button_new (HILDON_SIZE_FINGER_HEIGHT,
            HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_value (HILDON_BUTTON(button_killer), "killall sshd");

    int status = WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh check"));

    if (status == 0)
        hildon_button_set_title (HILDON_BUTTON(button_toggle), "SSHD ON");
    else
        hildon_button_set_title (HILDON_BUTTON(button_toggle), "SSHD OFF");

    g_signal_connect_after (G_OBJECT (button_toggle), "clicked",
            G_CALLBACK (ssh_status_button_toggle), plugin);

    g_signal_connect_after (G_OBJECT (button_killer), "clicked",
            G_CALLBACK (ssh_status_button_killer), plugin);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (hbox), button_toggle);
    gtk_container_add (GTK_CONTAINER (hbox), button_killer);
    gtk_container_add (GTK_CONTAINER (plugin), hbox);

    gtk_widget_show_all (button_toggle);
    gtk_widget_show_all (button_killer);
    gtk_widget_show_all (hbox);
    gtk_widget_show (GTK_WIDGET (plugin));
}

static gboolean toggle(gpointer plugin)
{
    int status =  WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh toggle"));

    if (status == 2) {
        hildon_button_set_title (HILDON_BUTTON(button_toggle), "SSHD OFF");
    } else if (status == 0) {
        hildon_button_set_title (HILDON_BUTTON(button_toggle), "SSHD ON");
    }

    return FALSE;
}

static void ssh_status_button_toggle (gpointer instance, gpointer plugin)
{
    g_idle_add(toggle, plugin);
}

static void ssh_status_button_killer (gpointer instance, gpointer plugin)
{
    WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh kill"));
}
