#ifndef MAPLISTITEM_H
#define MAPLISTITEM_H

//#include <QObject>

#include <QListWidgetItem>
#include <QDebug>
#include "squeezster_icons.h"
#include "metatypes.h"

typedef QVariantMap* variantMap_ptr;

class MapListItem : public QListWidgetItem
{
    //Q_OBJECT
public:
    //enum {Type = QListWidgetItem::UserType+1 };
    enum {Type = 1003 };
    explicit MapListItem(QListWidget* parent = 0);
    ~MapListItem() {delete map_i;}

    static const int MapItemCol = 0;
    static const int MapItem = 128;
    void setMap(QVariantMap map);
    void addProperty(QString key, QString val);
    QString property(QString key);
    void setTitle(QString title="");
    void setIcon();
    void setIcon(QIcon icon) {QListWidgetItem::setIcon(icon);}
    bool isRemote() {return((property("remote")=="1")?true:false);}
    QString command() {return(property("cmd"));}
    QString title() {return(property("title"));}
    QString artist() {return(property("artist"));}
    QString name() {return(property("name"));}
    QString playlist() {return(property("playlist"));}
    QString id() {return(property("id"));}
    QString type() {return(property("type"));}
    QString search() {return(property("search"));}
    QString item_id() {return(QString("item_id:"+property("id")));}
    QString album_id() {return(QString("album_id:"+property("id")));}
    QString folder_id() {return(QString("folder_id:"+property("id")));}
    QString track_id() {return(QString("track_id:"+property("id")));}
    QString genre_id() {return(QString("genre_id:"+property("id")));}
    QString playlist_id() {return(QString("playlist_id:"+property("id")));}
    quint16 playlistIndex() {return(property("playlist index").toInt());}
    float duration() {return(property("duration").toFloat());}
    //QString albumArtUrl(QString ipAddress, quint16 httpPort);

signals:

public slots:


private:
    //QVariant variant;
    QVariantMap* map_i;
};

Q_DECLARE_METATYPE(MapListItem);
Q_DECLARE_METATYPE(MapListItem*);

#endif // MAPLISTITEM_H
