#include "maptreeitem.h"

MapTreeItem::MapTreeItem() :
        QTreeWidgetItem(Type)
{
    QVariant variant;
    map_i=new QVariantMap();
    qVariantSetValue(variant,map_i);
    setData(MapItemCol,MapItem,variant);
}

void MapTreeItem::setMap(QVariantMap map)
{
    QVariant variant;
    delete map_i;
    map_i=new QVariantMap(map);
    qVariantSetValue(variant,map_i);
    setData(MapItemCol,MapItem,variant);
}

void MapTreeItem::setTitle(QString title)
{
    if (!title.isEmpty()) {
        setText(MapItemCol,title);
    } else if(property("cmd")==QString("albums")) {
        setText(MapItemCol,property("album"));
    } else if(property("cmd")==QString("titles")) {
        setText(MapItemCol,property("title"));
    } else if(property("cmd")==QString("artists")) {
        setText(MapItemCol,property("artist"));
    } else if(property("cmd")==QString("musicfolder")) {
        setText(MapItemCol,property("filename"));
    } else if(!(property("name").isEmpty())) {
        setText(MapItemCol,property("name"));
    }
    //qDebug() << "MapTreeItem::setTitle(QString title)" << QTreeWidgetItem::text(MapItemCol);
}

void MapTreeItem::addProperty(QString key, QString val)
{
    //qDebug()<< "addProperty #1"<< key << val;
    (*map_i)[key]=val;
}

QString MapTreeItem::property(QString key)
{
    return(map_i->value(key).toString());
}

void MapTreeItem::setIcon()
{
    if(command()==QString("musicfolder")) {
        if(typeFolder())
            setIcon(QIcon(SMALLMUSICNOTESPIXMAPFILE));
        if(typeTrack())
            setIcon(QIcon(SMALLWHITENOTEPIXMAPFILE));
    }
    else if(command()==QString("titles")) {
        setIcon(QIcon(SMALLWHITENOTEPIXMAPFILE));
    }
    else if(!hasItems()) {
        (isAudio()?setIcon(QIcon(SMALLWHITENOTEPIXMAPFILE)):setIcon(QIcon(SMALLBULLETPIXMAPFILE)));}
    else
        setIcon(QIcon(SMALLMUSICNOTESPIXMAPFILE));
}


