#include "connectiondialog.h"
#include "ui_connectiondialog.h"
#include "woldialog.h"

connectionDialog::connectionDialog(const QVariantMap &oldSettings, const QVariantList &lServerList, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::connectionDialog)
{
    lOldSettings=oldSettings;
    setServerList(lServerList);
    ui->setupUi(this);

    connect(this,SIGNAL(serverListChanged()),this,SLOT(updateIpAddressComboBox()));

    ui->httpPortLineEdit->setText(oldSettings.value("httpport").toString());
    ui->usernameLineEdit->setText(oldSettings.value("username").toString());
    ui->passwordLineEdit->setText(oldSettings.value("password").toString());
    ui->mysbUsernameLineEdit->setText(oldSettings.value("mysbusername").toString());
    ui->mysbPasswordLineEdit->setText(oldSettings.value("mysbpassword").toString());
    ui->mysbRadioButton->setChecked(oldSettings.value("mysb").toBool());
    wolMac_i = oldSettings.value("wolmac").toString();
    wolPort_i = oldSettings.value("wolport").toUInt();

    ui->ipAddressLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->httpPortLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->usernameLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->passwordLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->mysbUsernameLabel->setVisible(ui->mysbRadioButton->isChecked());
    ui->mysbPasswordLabel->setVisible(ui->mysbRadioButton->isChecked());
    ui->ipAddressComboBox->setVisible(!ui->mysbRadioButton->isChecked());
    ui->httpPortLineEdit->setVisible(!ui->mysbRadioButton->isChecked());
    ui->usernameLineEdit->setVisible(!ui->mysbRadioButton->isChecked());
    ui->passwordLineEdit->setVisible(!ui->mysbRadioButton->isChecked());
    ui->mysbUsernameLineEdit->setVisible(ui->mysbRadioButton->isChecked());
    ui->mysbPasswordLineEdit->setVisible(ui->mysbRadioButton->isChecked());

    connect(ui->ipAddressComboBox,SIGNAL(currentIndexChanged(int)),this,SLOT(on_currentIndex_changed(int)));
    ui->ipAddressComboBox->addItem(oldSettings.value("ipaddress").toString(),oldSettings.value("ipaddress").toString());

    for(int i=0;i<serverList().count();i++) {
        //if(serverList().at(i).toMap().value("ip").toString() != ui->ipAddressComboBox->itemText(0))
            ui->ipAddressComboBox->addItem(QString(serverList().at(i).toMap().value("ip").toString()+" ("+
                                                   serverList().at(i).toMap().value("name").toString()+")"),
                                           serverList().at(i).toMap().value("ip").toString());
    }
    ui->ipAddressComboBox->setCurrentIndex(0);
}

connectionDialog::~connectionDialog()
{
    delete ui;
}

void connectionDialog::updateIpAddressComboBox() {
    qDebug() << "updateIpAddressComboBox()"; // << serverList();

    bool found;
    for(int i=0;i<serverList().count();i++) {
        found=false;
        for(int j=0;j<ui->ipAddressComboBox->count();j++) {
            if(ui->ipAddressComboBox->itemData(j).toString()==serverList().at(i).toMap().value("ip").toString())
                found=true;
        }
        if(!found) {
            ui->ipAddressComboBox->addItem(QString(serverList().at(i).toMap().value("ip").toString()+" ("+
                                                   serverList().at(i).toMap().value("name").toString()+")"),
                                           serverList().at(i).toMap().value("ip").toString());
        }
    }
}

void connectionDialog::on_currentIndex_changed(int index) {
    if(index==0)
        ui->httpPortLineEdit->setText(lOldSettings.value("httpport").toString());
    else if(index>0)
        ui->httpPortLineEdit->setText(QString(serverList().at(index-1).toMap().value("port").toString()));
}

void connectionDialog::on_acceptPushButton_clicked()
{
    bool ok;
    QVariantMap newSettings;
    if (ui->httpPortLineEdit->text().toInt(&ok) && ok)
        newSettings["httpport"]=ui->httpPortLineEdit->text().toInt();
    else
        newSettings["httpport"]=9000;
    newSettings["ipaddress"]=ui->ipAddressComboBox->itemData(ui->ipAddressComboBox->currentIndex()).toString();
    newSettings["username"]=ui->usernameLineEdit->text();
    newSettings["password"]=ui->passwordLineEdit->text();
    newSettings["mysbusername"]=ui->mysbUsernameLineEdit->text();
    newSettings["mysbpassword"]=ui->mysbPasswordLineEdit->text();
    newSettings["mysb"]=ui->mysbRadioButton->isChecked();
    newSettings["wolmac"]=wolMac_i;
    newSettings["wolport"]=wolPort_i;
    emit connectionSettingsUpdated(newSettings);
    emit coreRestartRequest();
    close();
}

//void connectionDialog::on_buttonBox_rejected()
//{
//    qDebug() << "Connection settings rejected";
//    exit(1);
//}

void connectionDialog::on_wolPushButton_clicked()
{
    qDebug() << "WOL Pushbutton clicked";
    wolDialog* wolDialogUI=new wolDialog(this,&wolMac_i,&wolPort_i);
    wolDialogUI->exec();
}


void connectionDialog::on_mysbRadioButton_toggled(bool checked)
{
    ui->ipAddressLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->httpPortLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->usernameLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->passwordLabel->setVisible(!ui->mysbRadioButton->isChecked());
    ui->mysbUsernameLabel->setVisible(ui->mysbRadioButton->isChecked());
    ui->mysbPasswordLabel->setVisible(ui->mysbRadioButton->isChecked());
    ui->ipAddressComboBox->setVisible(!ui->mysbRadioButton->isChecked());
    ui->httpPortLineEdit->setVisible(!ui->mysbRadioButton->isChecked());
    ui->usernameLineEdit->setVisible(!ui->mysbRadioButton->isChecked());
    ui->passwordLineEdit->setVisible(!ui->mysbRadioButton->isChecked());
    ui->mysbUsernameLineEdit->setVisible(ui->mysbRadioButton->isChecked());
    ui->mysbPasswordLineEdit->setVisible(ui->mysbRadioButton->isChecked());
}
