#include "woldialog.h"
#include "ui_woldialog.h"

wolDialog::wolDialog(QWidget *parent,QString* wolMac, quint16* wolPort ) :
    QDialog(parent),
    ui(new Ui::wolDialog)
{
    ui->setupUi(this);

    wolMac_i="";
    quint16 wolPort_u16=WOLPORT;
    wolMacPtr = wolMac;
    wolPortPtr = wolPort;
    if (!wolMac->isEmpty())
        wolMac_i = *wolMac;
    if (!wolPort==0)
        wolPort_u16 = *wolPort;
    wolPort_i = wolPort_u16;

    // Fill in saved wolMac:
    QStringList macFields = wolMac_i.split(":");
    // Set default value if it not exists:
    qDebug() << "wolDialog::wolDialog() macFields.count()" << macFields.count() << "mac: " << wolMac_i;
    if(macFields.count()!=6)
        macFields = QString("00:00:00:00:00:00").split(":");

    ui->wolLineEdit5->setText(macFields.takeFirst());
    ui->wolLineEdit4->setText(macFields.takeFirst());
    ui->wolLineEdit3->setText(macFields.takeFirst());
    ui->wolLineEdit2->setText(macFields.takeFirst());
    ui->wolLineEdit1->setText(macFields.takeFirst());
    ui->wolLineEdit0->setText(macFields.takeFirst());
    ui->wolPortlineEdit->setText(QString::number(wolPort_i));

    connect(ui->wolLineEdit5,SIGNAL(textChanged(QString)),this, SLOT(checkTwoCharacters(QString)));
    connect(ui->wolLineEdit4,SIGNAL(textChanged(QString)),this, SLOT(checkTwoCharacters(QString)));
    connect(ui->wolLineEdit3,SIGNAL(textChanged(QString)),this, SLOT(checkTwoCharacters(QString)));
    connect(ui->wolLineEdit2,SIGNAL(textChanged(QString)),this, SLOT(checkTwoCharacters(QString)));
    connect(ui->wolLineEdit1,SIGNAL(textChanged(QString)),this, SLOT(checkTwoCharacters(QString)));
    connect(ui->wolLineEdit0,SIGNAL(textChanged(QString)),this, SLOT(checkTwoCharacters(QString)));
}

void wolDialog::checkTwoCharacters(QString text)
{
    if(text.length()==2)
        focusNextChild();
}

QString wolDialog::wolMac()
{
    if ((ui->wolLineEdit5->text().length()==2) &&
            (ui->wolLineEdit4->text().length()==2) &&
            (ui->wolLineEdit3->text().length()==2) &&
            (ui->wolLineEdit2->text().length()==2) &&
            (ui->wolLineEdit1->text().length()==2) &&
            (ui->wolLineEdit0->text().length()==2))
    {
        wolMac_i=QString(ui->wolLineEdit5->text().toLower()+":"+
                          ui->wolLineEdit4->text().toLower()+":"+
                          ui->wolLineEdit3->text().toLower()+":"+
                          ui->wolLineEdit2->text().toLower()+":"+
                          ui->wolLineEdit1->text().toLower()+":"+
                          ui->wolLineEdit0->text().toLower());
    }
    qDebug() << "wolDialog::wolMac() " << wolMac_i;
    return(wolMac_i);
}

wolDialog::~wolDialog()
{
    delete ui;
}

void wolDialog::on_sendWolPushButton_clicked()
{
    qDebug() << "wolDialog::on_sendWolPushButton_clicked() " << wolMac();
    bool ok;
    int i;
    quint16 port = 3483;
    port = ui->wolPortlineEdit->text().toInt();
    QStringList macFields = wolMac().split(":");
    if (macFields.count()!=6)
        return;

    QUdpSocket *serverUdpSocket = new QUdpSocket(this);

    QByteArray datagram;
    datagram.resize(102);
    datagram[0] = 0xFF;
    datagram[1] = 0xFF;
    datagram[2] = 0xFF;
    datagram[3] = 0xFF;
    datagram[4] = 0xFF;
    datagram[5] = 0xFF;

    for(i=0;i<16;i++) {
        datagram[6*i+6]  = macFields.at(0).toShort(&ok,16);
        datagram[6*i+7]  = macFields.at(1).toShort(&ok,16);
        datagram[6*i+8]  = macFields.at(2).toShort(&ok,16);
        datagram[6*i+9]  = macFields.at(3).toShort(&ok,16);
        datagram[6*i+10] = macFields.at(4).toShort(&ok,16);
        datagram[6*i+11] = macFields.at(5).toShort(&ok,16);
    }
    qDebug() << "MAC: " << wolMac();
    qDebug() << "MAC: " << macFields.at(0).toShort(&ok,16);
    qDebug() << "MAC: " << macFields.at(1).toShort(&ok,16);
    qDebug() << "MAC: " << macFields.at(2).toShort(&ok,16);
    qDebug() << "MAC: " << macFields.at(3).toShort(&ok,16);
    qDebug() << "MAC: " << macFields.at(4).toShort(&ok,16);
    qDebug() << "MAC: " << macFields.at(5).toShort(&ok,16);

    // Send Magic Packet
    serverUdpSocket->writeDatagram(datagram.data(), datagram.size(),
                                   QHostAddress::Broadcast, port);


    serverUdpSocket->close();
    qDebug() << "wolDialog: WOL datagram: " << datagram;
    serverUdpSocket->deleteLater();
}

void wolDialog::on_buttonBox_accepted()
{
    wolPort_i = ui->wolPortlineEdit->text().toUInt();
    quint16 wolPort_u16 = wolPort_i;
    wolMacPtr->clear();
    wolMacPtr->append(wolMac());
    *wolPortPtr = wolPort_u16;
    qDebug() << "wolDialog::on_buttonBox_accepted() " << *wolMacPtr;
}
