#include "usersettings.h"


UserSettings::UserSettings()
{
    setIpAddress(IPADDRESS);
    setHttpPort(HTTPPORT);
    setCliPort(CLIPORT);
    setUsername("");
    setPassword("");
    setScreensaverIsInhibited(false);
    setLargeAlbumIcons(false);
    setAlbumIcons(false);
}


QString UserSettings::setIpAddress(QString newIpAddress)
{
    ipAddress_i = newIpAddress;
    return(newIpAddress);
}

quint16 UserSettings::setHttpPort(quint16 newHttpPort)
{
    httpPort_i = newHttpPort;
    return(newHttpPort);
}

quint16 UserSettings::setCliPort(quint16 newCliPort)
{
    cliPort_i = newCliPort;
    return(newCliPort);
}


QString UserSettings::setUsername(QString newUsername)
{
    username_i= newUsername;
    return(newUsername);
}

QString UserSettings::setPassword(QString newPassword)
{
    password_i = newPassword;
    return(newPassword);
}

bool UserSettings::setScreensaverIsInhibited(bool newScreensaverInhibited)
{
    screensaverIsInhibited_i = newScreensaverInhibited;
    return(newScreensaverInhibited);
}

bool UserSettings::setLargeAlbumIcons(bool newLargeAlbumIcons)
{
    largeAlbumIcons_i = newLargeAlbumIcons;
    return(newLargeAlbumIcons);
}

bool UserSettings::setAlbumIcons(bool newAlbumIcons)
{
    albumIcons_i = newAlbumIcons;
    return(newAlbumIcons);
}

//bool UserSettings::load()
//{
//    QFile configFile(CONFIGFILE);
//    bool ok=true;
//    UserSettings newSettings;
//    qDebug() << "UserSettings::load()";
//    if (configFile.open(QIODevice::ReadOnly | QIODevice::Text))
//    {
//        QString string;
//        string = configFile.readLine();
//        if (!string.isNull()) {
//            qDebug() << "Read:" << string;
//            newSettings.setIpAddress(string.trimmed()); }
//        else ok=false;

//        string = configFile.readLine();
//        if (!string.isNull()) {
//            qDebug() << "Read:" << string;
//            newSettings.setHttpPort(string.toUInt()); }
//        else ok=false;

//        string = configFile.readLine();
//        if (!string.isNull()) {
//            qDebug() << "cliport:" << string;
//            newSettings.setCliPort(string.toUInt());
//  }
//        else ok=false;

//        string = configFile.readLine();
//        if (!string.isNull())
//            newSettings.setUsername(string.trimmed());
//        else ok=false;

//        string = configFile.readLine();
//        if (!string.isNull())
//            newSettings.setPassword(string.trimmed());
//        else ok=false;
//        configFile.close();
//    }
//    else ok=false;

//    if(!ok) {
//        newSettings = UserSettings();
//        newSettings.save(); }
//    else {
//        setIpAddress(newSettings.ipAddress());
//        setHttpPort(newSettings.httpPort());
//        setCliPort(newSettings.cliPort());
//        setUsername(newSettings.username());
//        setPassword(newSettings.password());
//    }

//    qDebug() << "Settings load() status:" << ok;

//    return(ok);

//}

//bool UserSettings::save()
//{
//    QFile configFile(CONFIGFILE);
//    qDebug() << "UserSettings::save()";
//    if (configFile.open(QIODevice::WriteOnly | QIODevice::Text))
//    {
//        configFile.write(ipAddress_i.trimmed().toUtf8());
//        configFile.write("\n");
//        configFile.write(QByteArray::number(httpPort_i));
//        configFile.write("\n");
//        configFile.write(QByteArray::number(cliPort_i));
//        configFile.write("\n");
//        configFile.write(username_i.trimmed().toUtf8());
//        configFile.write("\n");
//        configFile.write(password_i.trimmed().toUtf8());
//        configFile.write("\n");
//        qDebug() << "Settings save() status: true";
//        return(true);
//    }
//    else {
//        qDebug() << "Settings save() status: false";
//        return(false);
//    }

//}

const bool UserSettings::operator==(const UserSettings &rhs)
const {
    return(
            (ipAddress_i==rhs.ipAddress()) &&
            (httpPort_i==rhs.httpPort()) &&
            (cliPort_i==rhs.cliPort()) &&
            (username_i==rhs.username()) &&
            (password_i==rhs.password()) //&&
            //(screensaverIsInhibited_i==rhs.screensaverIsInhibited())
            );
}

const bool UserSettings::operator!=(const UserSettings &rhs)
const {
    return(
            (ipAddress_i!=rhs.ipAddress()) ||
            (httpPort_i!=rhs.httpPort()) ||
            (cliPort_i!=rhs.cliPort()) ||
            (username_i!=rhs.username()) ||
            (password_i!=rhs.password()) // ||
            //(screensaverIsInhibited_i!=rhs.screensaverIsInhibited())
            );
}

bool UserSettings::clone (const UserSettings &other)
{
    ipAddress_i=other.ipAddress();
    httpPort_i=other.httpPort();
    cliPort_i=other.cliPort();
    username_i=other.username();
    password_i=other.password();
    screensaverIsInhibited_i=other.screensaverIsInhibited();
    largeAlbumIcons_i=other.largeAlbumIcons();
    albumIcons_i=other.albumIcons();
return(true);
}


