#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include <QDialog>
#include <QMessageBox>
#include "version.h"

namespace Ui {
    class OptionsDialog;
}

class OptionsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit OptionsDialog(QWidget *parent = 0);
    ~OptionsDialog();

    void setScreensaverInhibitedState(bool ssInhibited);

signals:
    void clearCache();
    void ssaverInhibit(bool checked);

private slots:
    void on_clearCachePushButton_clicked();
    void on_ssaverCheckBox_toggled(bool checked);

    void on_aboutPushButton_clicked();

private:
    Ui::OptionsDialog *ui;
};

#endif // OPTIONSDIALOG_H
