#include "usersettings.h"


UserSettings::UserSettings()
{
    setIpAddress(IPADDRESS);
    setHttpPort(HTTPPORT);
    setCliPort(CLIPORT);
    setUsername("");
    setPassword("");
    setScreensaverIsInhibited(false);
    setLargeAlbumIcons(false);
    setAlbumIcons(false);
    setWolMac("00:00:00:00:00:00");
    setWolPort(WOLPORT);
}


QString UserSettings::setIpAddress(QString newIpAddress)
{
    ipAddress_i = newIpAddress;
    return(newIpAddress);
}

quint16 UserSettings::setHttpPort(quint16 newHttpPort)
{
    httpPort_i = newHttpPort;
    return(newHttpPort);
}

quint16 UserSettings::setCliPort(quint16 newCliPort)
{
    cliPort_i = newCliPort;
    return(newCliPort);
}


QString UserSettings::setUsername(QString newUsername)
{
    username_i= newUsername;
    return(newUsername);
}

QString UserSettings::setPassword(QString newPassword)
{
    password_i = newPassword;
    return(newPassword);
}

bool UserSettings::setScreensaverIsInhibited(bool newScreensaverInhibited)
{
    screensaverIsInhibited_i = newScreensaverInhibited;
    return(newScreensaverInhibited);
}

bool UserSettings::setLargeAlbumIcons(bool newLargeAlbumIcons)
{
    largeAlbumIcons_i = newLargeAlbumIcons;
    return(newLargeAlbumIcons);
}

bool UserSettings::setAlbumIcons(bool newAlbumIcons)
{
    albumIcons_i = newAlbumIcons;
    return(newAlbumIcons);
}

QString UserSettings::setWolMac(QString newWolMac)
{
    wolMac_i = newWolMac;
    return(newWolMac);
}

quint16 UserSettings::setWolPort(quint16 newWolPort)
{
    wolPort_i = newWolPort;
    return(newWolPort);
}


const bool UserSettings::operator==(const UserSettings &rhs)
const {
    return(
                (ipAddress_i==rhs.ipAddress()) &&
                (httpPort_i==rhs.httpPort()) &&
                (cliPort_i==rhs.cliPort()) &&
                (username_i==rhs.username()) &&
                (password_i==rhs.password()) &&
                (wolMac_i==rhs.wolMac()) &&
                (wolPort_i==rhs.wolPort())
                //(screensaverIsInhibited_i==rhs.screensaverIsInhibited())
                );
}

const bool UserSettings::operator!=(const UserSettings &rhs)
const {
    return(
                (ipAddress_i!=rhs.ipAddress()) ||
                (httpPort_i!=rhs.httpPort()) ||
                (cliPort_i!=rhs.cliPort()) ||
                (username_i!=rhs.username()) ||
                (password_i!=rhs.password()) ||
                (wolMac_i!=rhs.wolMac()) ||
                (wolPort_i!=rhs.wolPort())
                //(screensaverIsInhibited_i!=rhs.screensaverIsInhibited())
                );
}

bool UserSettings::clone (const UserSettings &other)
{
    ipAddress_i=other.ipAddress();
    httpPort_i=other.httpPort();
    cliPort_i=other.cliPort();
    username_i=other.username();
    password_i=other.password();
    screensaverIsInhibited_i=other.screensaverIsInhibited();
    largeAlbumIcons_i=other.largeAlbumIcons();
    albumIcons_i=other.albumIcons();
    wolMac_i=other.wolMac();
    wolPort_i=other.wolPort();
    return(true);
}


