#ifndef squeezster_H
#define squeezster_H

#include <algorithm>
#include <QtNetwork>
#include <QHash>
#include <QList>
#include <QVariant>
#include <QMainWindow>
#include <QtGui>
#include <QTcpSocket>
#include <QUdpSocket>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QListWidgetItem>
#include <QTreeWidgetItem>
#include <QUrl>
#include <QTimer>
#include <QStringList>
#include <QFontMetrics>
#include <QSettings>
#include "connectiondialog.h"
#include "squeezeresponse.h"
#include "xmltreeitem.h"
#include "xmllistitem.h"
#include "squeezster_icons.h"
#include "pushbuttonnetworkrequest.h"
#include "listwidgetitemnetworkrequest.h"
#include "treewidgetitemnetworkrequest.h"
#include "usersettings.h"
#include "metatypes.h"


// Debug configuration:
//#define QT_NO_DEBUG
//#define QT_DEBUG
#define INSTALLMSGHANDLER
//#define NODEBUG
//#define DEBUGTOFILE
//#define DEBUGTOSTDERR

// Constants;
#define VERSION "0.3.2"
#define NORMALSCREENOFFSET 46
#define SUBSCRIBEINTERVAL 30
#define PROGRESSINTERVAL 5000
#define RESPONSEINTERVAL 300
#define PROGRESSSTEP 2
#define ITEMSELECTTIME 500
#define MAXITEMSPERREQUEST 100
#define MAXTREEITEMSPERREQUEST 5000
#define DISKCACHESIZE 16384*16
#define MAXCONNECTTRIES 3
#define DISCOVERYPORT_SC 3483
#define DISCOVERYPORT_CS 3483


#define STATUSTAGS "tags:alsdxK"
#define ALBUMTAGS "tags:ailjce"
#define IDTAGS "tags:pse"

namespace Ui {
    class squeezster;
}


//class QTcpSocket;
//class QNetworkSession;



class squeezePlayer : public QObject
{
    Q_OBJECT

public:
    squeezePlayer() {
        isMaster = false;
        isSlave = false;
        isRemote = false;
        power = false;
        updateAlbumArt = true;
        songChanged = false;
        currentSongID="";
        currentAlbumArtURL="";
        remoteAlbumArtURL="";
        playlistIndex = 32000;
        prevPlaylistIndex = 32000;
    }

    void setPlayerID(QString newID) {playerID = newID;}
    void setPlayerIP(QString newIP) {playerIP = newIP;}
    void setPlayerName(QString newName) {playerName = newName;}
    void setPlayerModel(QString newModel) {playerModel = newModel;}
    void setCurrentSongID(QString songID) {currentSongID = songID;}
    void setCurrentArtist(QString artist) {currentArtist = artist;}
    void setCurrentTitle(QString title) {currentTitle = title;}
    void setCurrentAlbum(QString album) {currentAlbum = album;}
    void setCurrentGenre(QString genre) {currentGenre = genre;}
    void setCurrentMode(QString mode) {currentMode = mode;}
    void setPower(bool powerOn) {power = powerOn;}
    void setCurrentDuration(float duration) {currentDuration = duration;}
    void setCurrentTime(float time) {currentTime = time;}
    void setCurrentVolume(quint16 volume) {currentVolume = volume;}
    void setCurrentAlbumArtURL(QString albumArtURL) {currentAlbumArtURL = albumArtURL;}
    void setRemoteAlbumArtURL(QString albumArtURL) {remoteAlbumArtURL = albumArtURL;}
    void setCurrentAlbumArt(QPixmap *albumArt) {currentAlbumArt = albumArt;}

    QString playerID;
    QString playerIP;
    QString playerName;
    QString playerModel;
    QString currentSongID;
    QString currentTitle;
    QString currentArtist;
    QString currentAlbum;
    QString currentGenre;
    quint16 currentVolume;
    float currentDuration;
    float currentTime;
    bool power;
    QString currentAlbumArtURL;
    QString remoteAlbumArtURL;
    QString currentMode;
    QPixmap *currentAlbumArt;
    QString remoteTitle;
    QString playlistRepeat;
    QString playlistShuffle;
    QString playlistMode;
    quint16 playlistTracks;
    quint16 playlistIndex;
    quint16 prevPlaylistIndex;
    QString masterPlayerID;
    QStringList slavePlayerID;
    QList<squeezePlayer*> slavePlayers;
    squeezePlayer *masterPlayer;

    bool isRemote;

    bool isMaster;
    bool isSlave;
    bool updateAlbumArt;
    bool songChanged;

public slots:
signals:
private:
};


class squeezeEnv : public QObject
{
    Q_OBJECT

public:
    squeezeEnv() {
        numberOfPlayers=0;
        initDone=false;
        activePlayerSet=false;
        playerChanged=false;
        favoritesChanged=false;
    }
    ~squeezeEnv() {
        while(!playerList.isEmpty())
            delete playerList.takeFirst();
    };

    qint16 numberOfPlayers;
    squeezePlayer *activePlayer;
    bool activePlayerSet;
    QList<squeezePlayer*> playerList;
    bool favoritesChanged;
    bool initDone;  
    bool playlistChanged;
    bool playerChanged;


    void addPlayer(squeezePlayer *newPlayer) {
        squeezePlayer *player = new squeezePlayer();
        player = newPlayer;
        playerList << player;
    }

    squeezePlayer* getPlayer(quint16 i) {if (i<numberOfPlayers) return playerList.at(i); else return 0;}
    squeezePlayer* getActivePlayer() {return(activePlayer);}

public slots:
signals:
private:
};



class squeezster : public QMainWindow
{
    Q_OBJECT

public:
    explicit squeezster(QWidget *parent = 0);
    ~squeezster();

signals:
    void playerStatusUpdated(squeezePlayer*);
    void activePlayerUpdated(squeezePlayer*);
    void pixmapDone();
    void initDone();

private:
    Ui::squeezster *ui;

    static const int xmlItemCol = 0;
    static const int httpObjectVariant = 1024;
    enum xmlListFlags {noUpdate,updateIcons};


    UserSettings settings;
    connectionDialog *connectionUI;
    QTcpSocket *tcpSocket;
    QUdpSocket *serverUdpSocket;
    QUdpSocket *clientUdpSocket;
    QTextStream *inout;
    QTextStream *inTS;
    QTextStream *outTS;
    QTimer progressTimer;
    QTimer itemSelectTimer;
    QListWidgetItem *itemPressed;
    QTreeWidgetItem *pressedTreeItem;
    quint16 connectTries;

    QNetworkSession *networkSession;
    QNetworkAccessManager *networkManager;
    QNetworkConfigurationManager manager;
    QNetworkDiskCache *diskCache;
    quint16 screenMode;

    squeezeResponse *myResponse;
    squeezeEnv     mySqueezeEnv;
    QVariant treeItemParent;
    QVariant listItemParent;
    QVariant itemSelected;

    QVariantHash xmlBrowserHash;
    QHash<QString,bool> responseWhitelist;
    QHash<QString,bool> responseBlacklist;

    bool pixmapBusy;
    QStringList busyList;
    QVariantMap httpGetMap;
    QList<QVariant*> pixmapDLList;
    QList<QUrl*> pixmapUrl;

    QIcon bulletIcon,smallBulletIcon,plusIcon,minusIcon,powerIcon,playIcon,pauseIcon,stopIcon;
    QIcon rewIcon,fwdIcon,noteIcon;
    QIcon emptyAlbumArtIcon;

    void updateStatus(squeezePlayer *player, QStringList *parameters);
    void updateRadiosApps(QString command, QStringList *parameters);
    void updateMixer(squeezePlayer *player, QStringList *parameters);
    void queryStatus(squeezePlayer *player);

    void writeSettings(const UserSettings newSettings);
    void readSettings(UserSettings &newSettings);


private slots:
    void startApp(bool isOnline=true);
    void constructConnDialog();
    bool requestConnect();
    void requestConnect(const UserSettings &newSettings);
    void initEnvironment();
    void initUI();
    void updateNowPlayingIcons();

    void downloadImage(QTreeWidgetItem* item, QString url);
    void downloadImage(xmlListItem* item, QString url);
    void downloadImage(QPushButton* item, QString url);
    void downloadAlbumImage(xmlListItem* item, QString id, UserSettings settings);
    void downloadAlbumImage(xmlListItem* item);

    void pixmapDownloaded(QNetworkReply *reply);


    void initTitlesTree();
    void initArtistsTree();
    void showAlbums();
    void showTitles();
    void showArtists();
    void showPlaylists();
    void showAbout();

    void albumsListIconView();
    void treeContextMenuHandler(QPoint point);
    void listContextMenuHandler(QPoint point);

    void displayError(QAbstractSocket::SocketError socketError);
    void incrementScreenMode();
    void setupScreenMode();
    void isBusy(const QString busyString=QString());
    void sessionOpened();
    void updateUI(squeezePlayer *player);
    void updateProgress();

    void updateActivePlayer(int index);
    void requestCurrentPlaylist();
    void requestSqueezeList(const QString command, quint16 count=100, quint16 start=0, quint16 batch=0, QString tags=QString());
    void requestSqueezeList(const QStringList command, quint16 count=100, quint16 start=0, quint16 batch=0, QString tags=QString());
    void playlistItemClicked(QListWidgetItem* song);
    void updateXmlBrowserList(const QString command="", QStringList *parameters=0, QString divider="id",QTreeWidget* parentTreeWidget=0);
    void updateXmlList(const QString listType, QListWidget* listParent, QStringList* itemList, const QString divider, xmlListFlags updateFlag=noUpdate);
    void treeItemClicked(QTreeWidgetItem* treeItem);
    void listItemClicked(QListWidgetItem* listItem);


    void sendPlay();
    void sendPause();
    void sendStop();
    void sendPower();
    void sendSkipBack();
    void sendSkipForward();
    void sendPlaylistIndex(quint16 index);
    void sendPlaylistClear();
    void sendList(QStringList command, quint16 count=0, quint16 start=0, QString tags=STATUSTAGS);

    void setNewProgress(int index);
    void setVolume(int index);
    void slotRepeat();
    void slotShuffle();
    void clearCache();
    void savePlaylist();

    quint16 responseIsList (QStringList *parameters, quint16 *pStartIndex, quint16 *pEndIndex);
    void slaveMasterConnect();
    QString responseHandler(QString responseString, bool init=false);
    void responseListHandler(QList<QByteArray> responseByteArrayList, bool init=false);
    QString send(const squeezePlayer *player, const QString command, const QStringList parameters=QStringList(),bool force=false);
    QString send(const QStringList commands,bool force=false);

    void itemUnselect();
    void splitKeyPair(QString keyPair, QString* keyName, QString* keyVal);
    qint16 getNumberOfPlayers(QString responseString);
    QString getKeyValue(QString responseString, QString keyName, bool* ok=0);
    QString getInitValue(QString responseString, QString keyName);
    QString getFirstKey(QStringList parameters, QString keyName);

    void receiveUdpDatagram();
    void serverDiscovery();
};

#endif // squeezster_H
