#ifndef SQUEEZSTER_UI_DEFINITIONS_H
#define SQUEEZSTER_UI_DEFINITIONS_H

#include "squeezster.h"
#include "ui_squeezster.h"
#include <QtDebug>

void squeezster::setupScreenMode()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()) {
        if(screenMode==1) {
            qDebug() << "Going fullscreen";
            this->showFullScreen();
            ui->skipBackButton->setGeometry(0,415,111,71);
            ui->playButton->setGeometry(111,415,111,71);
            ui->pauseButton->setGeometry(220,415,101,71);
            ui->stopButton->setGeometry(320,415,101,71);
            ui->skipFwdButton->setGeometry(420,415,111,71);
            ui->playerComboBox->setGeometry(530,415,201,71);
            ui->powerButton->setGeometry(730,415,75,71);
            ui->powerButton->show();
            ui->squeezeTabWidget->setGeometry(0, 0, 480, 415);
            ui->nowPlayingListWidget->setGeometry(0, 0, 480, 336);
            ui->favoritesTreeWidget->setGeometry(0, 0, 480, 336);
            ui->albumsListWidget->setGeometry(0, 0, 480, 336);
            ui->radiosTreeWidget->setGeometry(0, 0, 480, 336);
            ui->appsTreeWidget->setGeometry(0, 0, 480, 336);
            ui->titlesTreeWidget->setGeometry(0, 0, 480, 336);
            ui->artistsTreeWidget->setGeometry(0, 0, 480, 336);
            ui->folderTreeWidget->setGeometry(0, 0, 480, 336);
            ui->playlistsListWidget->setGeometry(0, 0, 480, 336);
            ui->stackedWidget->setGeometry(0, 0, 480, 336);
            ui->line->setGeometry(479,0,16,411);
            ui->volumeSlider->setGeometry(750,30,51,361);
            ui->progressBar->setGeometry(QRect(500, 242, 241, 51));
            ui->albumArtLabel->setGeometry(501,1,240,240);
            ui->albumArtLabel->setIconSize(QSize(240,240));
            ui->albumLabel->setGeometry(QRect(500, 320, 221, 31));
            ui->titleLabel->setGeometry(QRect(500, 290, 221, 31));
            ui->artistLabel->setGeometry(QRect(500, 350, 221, 31));
            ui->albumLabel->show();
            ui->albumArtBackground->setGeometry(QRect(500, 0, 242, 242));
            ui->albumArtBackground->show();
            ui->squeezeTabWidget->show();
            ui->nowPlayingListWidget->show();
            ui->favoritesTreeWidget->show();
            ui->albumsListWidget->show();
            ui->radiosTreeWidget->show();
            ui->appsTreeWidget->show();
            ui->line->show();
            ui->volumeSlider->show();
        }
        else if(screenMode==2){
            qDebug() << "Going albumart screen";
            this->showFullScreen();
            ui->skipBackButton->setGeometry(0,415,111,71);
            ui->playButton->setGeometry(111,415,111,71);
            ui->pauseButton->setGeometry(220,415,101,71);
            ui->stopButton->setGeometry(320,415,101,71);
            ui->skipFwdButton->setGeometry(420,415,111,71);
            ui->playerComboBox->setGeometry(530,415,201,71);
            ui->powerButton->setGeometry(730,415,75,71);
            ui->powerButton->show();
            ui->squeezeTabWidget->setGeometry(0, 0, 480, 415);
            ui->nowPlayingListWidget->setGeometry(0, 0, 480, 336);
            ui->favoritesTreeWidget->setGeometry(0, 0, 480, 336);
            ui->albumsListWidget->setGeometry(0, 0, 480, 336);
            ui->radiosTreeWidget->setGeometry(0, 0, 480, 336);
            ui->appsTreeWidget->setGeometry(0, 0, 480, 336);
            ui->titlesTreeWidget->setGeometry(0, 0, 480, 336);
            ui->artistsTreeWidget->setGeometry(0, 0, 480, 336);
            ui->playlistsListWidget->setGeometry(0, 0, 480, 336);
            ui->folderTreeWidget->setGeometry(0, 0, 480, 336);
            ui->line->setGeometry(479,0,16,411);
            ui->volumeSlider->setGeometry(750,30,51,361);
            ui->albumArtLabel->setGeometry(800-480,0,415,415);
            ui->progressBar->setGeometry(QRect(20, 320, 300, 51));
            ui->albumArtLabel->setIconSize(QSize(415,415));
            ui->titleLabel->setGeometry(QRect(20, 200, 300, 31));
            ui->albumLabel->setGeometry(QRect(20, 230, 300, 31));
            ui->artistLabel->setGeometry(QRect(20, 260, 300, 31));
            ui->albumLabel->show();
            ui->albumArtBackground->setGeometry(QRect(500, 0, 242, 242));
            ui->albumArtBackground->hide();
            ui->squeezeTabWidget->hide();
            ui->nowPlayingListWidget->hide();
            ui->favoritesTreeWidget->hide();
            ui->albumsListWidget->hide();
            ui->radiosTreeWidget->hide();
            ui->appsTreeWidget->hide();
            ui->line->hide();
            ui->volumeSlider->show();
        }
        else { // if(screenMode==0){
            qDebug() << "Going normal screen";
            this->showNormal();
            ui->skipBackButton->setGeometry(0,360,111,71);
            ui->playButton->setGeometry(111,360,111,71);
            ui->pauseButton->setGeometry(220,360,101,71);
            ui->stopButton->setGeometry(320,360,101,71);
            ui->skipFwdButton->setGeometry(420,360,111,71);
            ui->playerComboBox->setGeometry(530,360,201,71);
            ui->powerButton->setGeometry(730,360,75,71);
            ui->squeezeTabWidget->setGeometry(0, 0, 480, 361);
            ui->nowPlayingListWidget->setGeometry(0, 0, 480, 286);
            ui->favoritesTreeWidget->setGeometry(0, 0, 480, 286);
            ui->albumsListWidget->setGeometry(0, 0, 480, 286);
            ui->radiosTreeWidget->setGeometry(0, 0, 480, 286);
            ui->appsTreeWidget->setGeometry(0, 0, 480, 286);
            ui->titlesTreeWidget->setGeometry(0, 0, 480, 286);
            ui->artistsTreeWidget->setGeometry(0, 0, 480, 286);
            ui->playlistsListWidget->setGeometry(0, 0, 480, 286);
            ui->folderTreeWidget->setGeometry(0, 0, 480, 286);
            ui->stackedWidget->setGeometry(0, 0, 480, 286);
            ui->line->setGeometry(479,0,16,361);
            ui->volumeSlider->setGeometry(QRect(750, 30, 51, 311));
            ui->albumArtLabel->setGeometry(501,1,240,240);
            ui->albumArtLabel->setIconSize(QSize(240,240));
            ui->albumLabel->setGeometry(QRect(500, 350, 221, 31));
            ui->albumLabel->hide();
            ui->titleLabel->setGeometry(QRect(500, 290, 221, 31));
            ui->artistLabel->setGeometry(QRect(500, 320, 221, 31));
            ui->albumArtBackground->setGeometry(QRect(500, 0, 242, 242));
            ui->progressBar->setGeometry(QRect(500, 242, 241, 51));
            ui->albumArtBackground->show();
            ui->squeezeTabWidget->show();
            ui->nowPlayingListWidget->show();
            ui->favoritesTreeWidget->show();
            ui->albumsListWidget->show();
            ui->radiosTreeWidget->show();
            ui->appsTreeWidget->show();
            ui->line->show();
            ui->volumeSlider->show();
        }
    } else // Portrait mode
    {
        ui->skipBackButton->setGeometry(QRect(0, 670, 90, 71));
        ui->playButton->setGeometry(QRect(90, 670, 120, 71));
        ui->pauseButton->setGeometry(QRect(210, 670, 90, 71));
        ui->stopButton->setGeometry(QRect(300, 670, 90, 71));
        ui->skipFwdButton->setGeometry(QRect(390, 670, 90, 71));
        ui->playerComboBox->setGeometry(QRect(0, 610, 201, 70));
        ui->powerButton->setGeometry(QRect(390, 610, 90, 70));
        ui->squeezeTabWidget->setGeometry(QRect(0, 242, 480, 366));
        ui->nowPlayingListWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->favoritesTreeWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->albumsListWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->radiosTreeWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->appsTreeWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->titlesTreeWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->artistsTreeWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->playlistsListWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->folderTreeWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->stackedWidget->setGeometry(QRect(0, 0, 480, 291));
        ui->line->hide();
        ui->volumeSlider->setGeometry(QRect(430, 0, 51, 251));
//        ui->albumArtLabel->setGeometry(QRect(181, 1, 240, 240));
        ui->albumArtLabel->setGeometry(QRect(240-100, 1, 200, 200));
        ui->albumArtLabel->setIconSize(QSize(200,200));
        ui->albumLabel->setGeometry(QRect(0, 100, 195, 31));
        ui->albumLabel->hide();
        ui->titleLabel->setGeometry(QRect(0, 205, 240, 31));
        ui->artistLabel->setGeometry(QRect(245, 205, 200, 31));
//        ui->albumArtBackground->setGeometry(QRect(180, 0, 242, 242));
        ui->albumArtBackground->setGeometry(QRect(240-101, 0, 202, 202));
        ui->progressBar->setGeometry(QRect(200, 610, 211, 70));
        ui->albumArtBackground->hide();
        ui->squeezeTabWidget->show();
        ui->nowPlayingListWidget->show();
        ui->favoritesTreeWidget->show();
        ui->albumsListWidget->show();
        ui->radiosTreeWidget->show();
        ui->appsTreeWidget->show();
        ui->line->hide();
        ui->volumeSlider->show();

        //ui->volumeLabel->setGeometry(QRect(430, 270, 41, 20));

    }
}



#endif // SQUEEZSTER_UI_DEFINITIONS_H
