#include "umkreissuche.h"
#include "ui_umkreissuche.h"
#include <QRegExp>

Umkreissuche::Umkreissuche(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Umkreissuche)
{
    ui->setupUi(this);
    plz = "";
    ort = "";
    strasse = "";
    umkreis = 10;
    kraftstoff = "Diesel";
}

Umkreissuche::~Umkreissuche()
{
    delete ui;
}

void Umkreissuche::on_buttonBox_accepted()
{
    plz = ui->lineEdit_plz->text();
    if(!QRegExp("\\d{5}").exactMatch(plz)){
        ui->lineEdit_plz->setText("");
        plz="";
    }
    ort = ui->lineEdit_ort->text();
    strasse = ui->lineEdit_str->text();
    if((plz!="") || (ort!="")) accept();
}

void Umkreissuche::on_comboBox_sprit_activated(int index)
{
    if(index==0) kraftstoff="Diesel";
    else if(index==1) kraftstoff="Super";
    else if(index==2) kraftstoff="SuperPlus";
    else if(index==3) kraftstoff="SuperE5";
    else if(index==4) kraftstoff="Autogas";
    else if(index==5) kraftstoff="Erdgas";
    else if(index==6) kraftstoff="Biodiesel";
    else kraftstoff="LKW-Diesel";
}



void Umkreissuche::on_comboBox_umkreis_activated(QString st)
{
    umkreis = st.toInt();
}
