// checksum 0xa193 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include <QDebug>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    source = QGeoPositionInfoSource::createDefaultSource(0);
    default_radius = 10;
    default_kraftstoff="Diesel";
    ladebalken = new LadebalkenWidget();
    ladebalken->setVisible(false);
    ui->centralWidget->layout()->addWidget(ladebalken);
    ui->centralWidget->layout()->setAlignment(ladebalken,Qt::AlignCenter);


    QVariant def1;
    QVariant def2;
    def1.setValue(default_radius);
    def2.setValue(default_kraftstoff);
    settings = new QSettings("/home/user/spritpreise.ini",QSettings::IniFormat);
    //qDebug()<<settings->status();
    default_radius = settings->value("Radius",def1).toInt();
    default_kraftstoff = settings->value("Kraftstoff",def2).toString();


    gmaps = new GMaps();
    connect(gmaps,SIGNAL(found_adresse(QString,QString,QString,QString)),this,SLOT(found_adresse(QString,QString,QString,QString)));
    connect(gmaps,SIGNAL(found_error(QString)),this,SLOT(found_error(QString)));
    connect(gmaps,SIGNAL(found_neterror(QString)),this,SLOT(found_neterror(QString)));

    clevertanken = new CleverTanken();
    connect(clevertanken,SIGNAL(tankstellenFounded(QList<Tankstelle>)),this,SLOT(showTankstellen(QList<Tankstelle>)));
    connect(clevertanken,SIGNAL(foundError(QString)),this,SLOT(found_neterror(QString)));



    if (source) {
        source->setPreferredPositioningMethods(QGeoPositionInfoSource::AllPositioningMethods);
        connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)),
            this, SLOT(gps_updated(QGeoPositionInfo)));
        source->startUpdates();
        loading(true,"Warte auf GPS..."); // GPS Koordinate suchen
    }

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::gps_updated(const QGeoPositionInfo &info){
    if(info.isValid()){
        if(info.coordinate().type()==QGeoCoordinate::Coordinate3D){
            source->stopUpdates();
            loading(false); // GPS Koordinate suchen fertig
            loading(true,"Ermittle Adresse...");  // Koordinaten umwandeln beginnen
            gmaps->geocordToAddress(info.coordinate().latitude(),info.coordinate().longitude());
        }
    }
}

void MainWindow::found_adresse(QString strasse, QString plz, QString ort, QString land){
    loading(false); // Koordinaten in Adresse umwandeln fertig
    loading(true,"Suche Tankstellen...");  // Tankstellen laden
    clevertanken->sucheTankstellen(plz,ort,strasse,default_radius,default_kraftstoff);
    this->setWindowTitle(default_kraftstoff);

}
void MainWindow::found_error(QString err){
    loading(false); // Fehler gefunden

}
void MainWindow::found_neterror(QString err){
    loading(false); // Fehler gefunden
}

void MainWindow::loading(bool l, QString text){
    if(l){
        ui->listWidget->setVisible(false);
        ladebalken->setVisible(true);
        ladebalken->setText(text);
    }else{
        ui->listWidget->setVisible(true);
        ladebalken->setVisible(false);
    }
}

void MainWindow::showTankstellen(QList<Tankstelle> tankstellen){
    ui->listWidget->clear();
    listwidgetitems.clear();
    wItems.clear();
    for(int i=0;i<tankstellen.size();i++){
        listwidgetitems.append(new QListWidgetItem());
        wItems.append(new Item());
        listwidgetitems.last()->setSizeHint(QSize(0,110));
        ui->listWidget->addItem(listwidgetitems.last());
        ui->listWidget->setItemWidget(listwidgetitems.last(),wItems.last());
        wItems.last()->setTankstelle(tankstellen[i]);
    }
    loading(false); // Tankstellen laden fertig
}

void MainWindow::on_actionUmkreissuche_triggered()
{
    if(source) source->stopUpdates();
    loading(false);
    Umkreissuche uks;
    if(uks.exec()==1){
        loading(true,"Suche Tankstellen...");
        clevertanken->sucheTankstellen(uks.plz,uks.ort,uks.strasse,uks.umkreis,uks.kraftstoff);
        this->setWindowTitle(uks.kraftstoff);
    }

}

void MainWindow::on_actionGPS_Suche_triggered()
{
    if(source) source->stopUpdates();
    loading(false);
    if(source) {
        source->stopUpdates();
        source->startUpdates();
        loading(true,"Warte auf GPS...");
    }
}

void MainWindow::on_actionEinstellungen_triggered()
{
    Einstellungen einstellungen(default_radius,default_kraftstoff);
    if(einstellungen.exec()==1){
        QVariant tmp;
        default_radius=einstellungen.getUmkreis();
        default_kraftstoff=einstellungen.getKraftstoff();
        tmp.setValue(default_radius);
        settings->setValue("Radius",tmp);
        tmp.setValue(default_kraftstoff);
        settings->setValue("Kraftstoff",tmp);
    }
}

void MainWindow::on_action_ber_triggered()
{
    About about;
    about.exec();
}
