#include "item.h"
#include "ui_item.h"
#include <QDebug>

Item::Item(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Item)
{
    ui->setupUi(this);
}

Item::~Item()
{
    delete ui;
}

/*void Item::resizeEvent(QResizeEvent *event){
    qDebug()<<"Resize";
}*/

void Item::setTankstelle(Tankstelle t){
    clear();
    ui->label_Name->setText(t.name);
    ui->label_str->setText(t.str);
    ui->label_plzort->setText(t.plz + " " + t.ort);
    ui->label_preis->setText(t.preis+" "+QString(QChar(8364)));
    ui->label_datum->setText(t.update_datum.toString("dd.MM.yyyy"));
    ui->label_zeit->setText(t.update_time.toString("hh:mm:ss"));
    if(t.name.contains("Aral",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/aral.png"));
    else if(t.name.contains("Shell",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/shell.png"));
    else if(t.name.contains("Esso",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/esso.png"));
    else if(t.name.contains("Jet",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/jet.png"));
    else if(t.name.contains("omv",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/omv.png"));
    else if(t.name.contains("bp",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/bp.png"));
    else if(t.name.contains("Go",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/go.png"));
    else if(t.name.contains("Hem",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/hem.png"));
    else if(t.name.contains("Oil",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/oil.png"));
    else if(t.name.contains("Star",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/star.png"));
    else if(t.name.contains("total",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/total.png"));
    else if(t.name.contains("Agip",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/agip.png"));
    else if(t.name.contains("BFT",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/bft.png"));
    else if(t.name.contains("SVG",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/svg.png"));
    else if(t.name.contains("AVIA",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/avia.png"));
    else if(t.name.contains("SB TANK",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/sbtank.png"));
    else if(t.name.contains("sprint",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/sprint.png"));
    else if(t.name.contains("BAVARIA PETROL",Qt::CaseInsensitive)) ui->label_icon->setPixmap(QPixmap(":/bilder/bavariapetrol.png"));
    else ui->label_icon->setPixmap(QPixmap(":/bilder/default.png"));
}

void Item::clear(){
    ui->label_Name->clear();
    ui->label_datum->clear();
    ui->label_icon->clear();
    ui->label_plzort->clear();
    ui->label_preis->clear();
    ui->label_str->clear();
    ui->label_zeit->clear();
}
